/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.Server;
import cn.nukkit.level.Location;
import cn.nukkit.utils.BinaryStream;
import java.util.Objects;
import lib.net.easecation.ghosty.entity.PlaybackNPC;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;

class UpdatedWorld
implements Updated {
    private String wn;

    @Override
    public int getUpdateTypeId() {
        return 3;
    }

    static UpdatedWorld of(String tn) {
        return new UpdatedWorld(tn);
    }

    @Override
    public void processTo(PlaybackNPC ghost) {
        Location location = ghost.getLocation();
        location.level = Server.getInstance().getLevelByName(this.wn);
        if (location.level == null) {
            return;
        }
        ghost.teleport(location);
    }

    @Override
    public RecordNode applyTo(RecordNode node) {
        node.setLevel(this.wn);
        return node;
    }

    public UpdatedWorld(BinaryStream stream) {
        this.read(stream);
    }

    private UpdatedWorld(String wn) {
        this.wn = wn;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatedWorld)) {
            return false;
        }
        UpdatedWorld o = (UpdatedWorld)obj;
        return Objects.equals(this.wn, o.wn);
    }

    @Override
    public void write(BinaryStream stream) {
        stream.putString(this.wn);
    }

    @Override
    public void read(BinaryStream stream) {
        this.wn = stream.getString();
    }
}

