/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.Server;

public class NukkitTypeUtils {
    private static final NukkitType nukkitType;

    public static NukkitType getNukkitType() {
        return nukkitType;
    }

    static {
        switch (Server.getInstance().getCodename().toLowerCase()) {
            case "powernukkitx": {
                nukkitType = NukkitType.POWER_NUKKIT_X;
                break;
            }
            case "powernukkit": {
                nukkitType = NukkitType.POWER_NUKKIT;
                break;
            }
            case "pm1e": {
                nukkitType = NukkitType.PM1E;
                break;
            }
            case "mot": {
                nukkitType = NukkitType.MOT;
                break;
            }
            default: {
                nukkitType = NukkitType.NUKKITX;
            }
        }
    }

    public static enum NukkitType {
        NUKKITX("NukkitX"),
        POWER_NUKKIT("PowerNukkit"),
        POWER_NUKKIT_X("PowerNukkitX"),
        PM1E("Nukkit PetteriM1 Edition"),
        MOT("Nukkit MOT");

        private final String showName;

        private NukkitType(String showName) {
            this.showName = showName;
        }

        public String getShowName() {
            return this.showName;
        }
    }
}

