/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.ranking;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.ranking.Ranking;
import cn.lanink.gamecore.ranking.task.AsyncUpdateTask;
import cn.lanink.gamecore.ranking.task.UpdateTask;
import cn.nukkit.level.Position;
import cn.nukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class RankingAPI {
    private static final RankingAPI rankingAPI = new RankingAPI();
    private boolean isEnabled;
    private AsyncUpdateTask asyncUpdateTask;
    private UpdateTask updateTask;

    public static RankingAPI getInstance() {
        return rankingAPI;
    }

    public void enable() {
        if (this.isEnabled) {
            return;
        }
        this.asyncUpdateTask = new AsyncUpdateTask(GameCore.getInstance());
        GameCore.getInstance().getServer().getScheduler().scheduleRepeatingTask((Plugin)GameCore.getInstance(), (Runnable)((Object)this.asyncUpdateTask), 1, true);
        this.updateTask = new UpdateTask(GameCore.getInstance());
        GameCore.getInstance().getServer().getScheduler().scheduleRepeatingTask((Plugin)GameCore.getInstance(), (Runnable)((Object)this.updateTask), 1);
        this.isEnabled = true;
    }

    public void disable() {
        if (!this.isEnabled) {
            return;
        }
        for (Ranking ranking : this.asyncUpdateTask.getRankings()) {
            ranking.close();
        }
        for (Ranking ranking : this.updateTask.getRankings()) {
            ranking.close();
        }
        this.isEnabled = false;
    }

    public static Ranking createRanking(@NotNull Plugin plugin, @NotNull String name, @NotNull Position position) {
        return new Ranking(plugin, name, position);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AsyncUpdateTask getAsyncUpdateTask() {
        return this.asyncUpdateTask;
    }

    public UpdateTask getUpdateTask() {
        return this.updateTask;
    }
}

