/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.pathfinder.astar;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.pathfinder.api.PathFinder;
import cn.lanink.gamecore.pathfinder.astar.AstarNode;
import cn.lanink.gamecore.pathfinder.utils.BlockUtil;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.level.Position;
import cn.nukkit.level.particle.DustParticle;
import cn.nukkit.level.particle.Particle;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.AsyncTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class AstarPathFinder
implements PathFinder {
    public static final int DEFAULT_TIME_LIMIT = 100;
    public static final double DEFAULT_POWER = 0.5;
    private final HashMap<Block, AstarNode> open = new HashMap();
    private final HashSet<AstarNode> close = new HashSet();
    private final Position start;
    private final Position target;
    private final long timeLimit;
    private double power;
    private final boolean asyncWork;
    private boolean isFinished = false;
    private boolean isSearching = false;
    private AstarNode result;
    private List<Vector3> resultList;
    private List<AstarNode> resultNodeList;
    protected AtomicInteger currentNode = new AtomicInteger(0);

    public AstarPathFinder(Position start, Position target) {
        this(start, target, 100);
    }

    public AstarPathFinder(Position start, Position target, int timeLimit) {
        this(start, target, timeLimit, 0.5);
    }

    public AstarPathFinder(Position start, Position target, long timeLimit, double power) {
        this(start, target, timeLimit, power, true);
    }

    public AstarPathFinder(Position start, Position target, long timeLimit, double power, boolean asyncWork) {
        this.start = start;
        this.target = target;
        this.timeLimit = timeLimit;
        this.power = power;
        this.asyncWork = asyncWork;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public Vector3 findNext() {
        if (!this.isFinished && !this.isSearching) {
            this.find();
        }
        if (this.getResult().size() > this.currentNode.get()) {
            return this.getResult().get(this.currentNode.getAndIncrement());
        }
        return null;
    }

    @Override
    @Deprecated
    public void find(boolean async) {
        this.find();
    }

    @Override
    public List<Vector3> find() {
        if (this.asyncWork) {
            Server.getInstance().getScheduler().scheduleAsyncTask((Plugin)GameCore.getInstance(), new AsyncTask(){

                public void onRun() {
                    AstarPathFinder.this.findRoute();
                }
            });
        } else {
            this.findRoute();
        }
        return this.getResult();
    }

    private void findRoute() {
        this.isFinished = false;
        this.isSearching = true;
        this.resultNodeList = null;
        this.resultList = null;
        long timeStart = System.currentTimeMillis();
        AstarNode startNode = new AstarNode(this.start, 0.0, BlockUtil.MHDistance((Vector3)this.start, (Vector3)this.target), null);
        this.open.put(startNode.levelBlock, startNode);
        while (!this.open.isEmpty() && System.currentTimeMillis() - timeStart <= this.timeLimit) {
            AstarNode minFNode = this.getMinFNode(this.power);
            if (minFNode.equals(this.target)) {
                this.result = minFNode;
                break;
            }
            this.open.remove(minFNode.levelBlock);
            this.close.add(minFNode);
            for (AstarNode nextNode : minFNode.getNextAccessibleNodes(this.target)) {
                if (this.close.contains(nextNode)) continue;
                if (this.open.containsKey(nextNode.levelBlock)) {
                    this.open.get(nextNode.levelBlock).update(nextNode);
                    continue;
                }
                this.open.put(nextNode.levelBlock, nextNode);
            }
        }
        this.isFinished = true;
        this.isSearching = false;
    }

    @Override
    public void show() {
        if (this.isFinished) {
            this.getResultNode().forEach(astarNode -> astarNode.position.getLevel().addParticle((Particle)new DustParticle((Vector3)astarNode.levelBlock.add(0.5, 0.2, 0.5), 255, 0, 0)));
        }
    }

    @Override
    public List<AstarNode> getResultNode() {
        if (!this.isFinished) {
            return new ArrayList<AstarNode>();
        }
        if (this.resultNodeList == null) {
            this.resultNodeList = new ArrayList<AstarNode>();
            AstarNode node = this.result;
            while (node != null) {
                this.resultNodeList.add(0, node);
                node = node.parent;
            }
        }
        return this.resultNodeList;
    }

    @Override
    public List<Vector3> getResult() {
        if (!this.isFinished) {
            return new ArrayList<Vector3>();
        }
        if (this.resultList == null) {
            this.resultList = new ArrayList<Vector3>();
            AstarNode node = this.result;
            while (node != null) {
                this.resultList.add(0, (Vector3)node.position);
                node = node.parent;
            }
        }
        return this.resultList;
    }

    private AstarNode getMinFNode(double power) {
        double minF = Double.MAX_VALUE;
        AstarNode ret = null;
        for (AstarNode node : this.open.values()) {
            double f = node.getF(power);
            if (!(f < minF)) continue;
            ret = node;
            minF = f;
        }
        return ret;
    }
}

