/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.inventory.PlayerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.utils.BinaryStream;
import lib.net.easecation.ghosty.entity.PlaybackNPC;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;

class UpdatedItem
implements Updated {
    private Item item;

    static UpdatedItem of(Item item) {
        return new UpdatedItem(item);
    }

    @Override
    public int getUpdateTypeId() {
        return 5;
    }

    @Override
    public void processTo(PlaybackNPC ghost) {
        if (ghost != null && ghost.getInventory() != null) {
            PlayerInventory inv = ghost.getInventory();
            inv.setItemInHand(this.item == null ? Item.get((int)0) : this.item);
            inv.sendHeldItem(ghost.getViewers().values());
        }
    }

    @Override
    public RecordNode applyTo(RecordNode node) {
        node.setItem(this.item);
        return node;
    }

    public UpdatedItem(BinaryStream stream) {
        this.read(stream);
    }

    private UpdatedItem(Item item) {
        this.item = item;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatedItem)) {
            return false;
        }
        UpdatedItem o = (UpdatedItem)obj;
        return this.item.equals((Object)o.item);
    }

    @Override
    public void write(BinaryStream stream) {
        stream.putSlot(this.item);
    }

    @Override
    public void read(BinaryStream stream) {
        this.item = stream.getSlot();
    }
}

