/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.Player;
import cn.nukkit.item.Item;
import java.io.Serializable;

public final class RecordNode
implements Serializable {
    private static final long serialVersionUID = -5809782578272943999L;
    private double x;
    private double y;
    private double z;
    private double yaw;
    private double pitch;
    private String level;
    private String tagName;
    private Item item;
    private long dataFlags;
    static RecordNode ZERO = new RecordNode(0.0, 0.0, 0.0, 0.0, 0.0, "", "", null, 0L);

    static RecordNode of(Player player) {
        Item hand = null;
        if (player.getInventory() != null) {
            hand = player.getInventory().getItemInHand();
        }
        return new RecordNode(player.getX(), player.getY(), player.getZ(), player.getYaw(), player.getPitch(), player.getLevel().getName(), player.getDisplayName(), hand, player.getDataPropertyLong(0));
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecordNode) {
            RecordNode node = (RecordNode)obj;
            return this.x == node.x && this.y == node.y && this.z == node.z && this.yaw == node.yaw && this.pitch == node.pitch && this.level.equals(node.level) && this.tagName.equals(node.tagName) && this.item.equals((Object)node.item);
        }
        return false;
    }

    private RecordNode(double x, double y, double z, double yaw, double pitch, String level, String tagName, Item item, long dataFlags) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.level = level;
        this.tagName = tagName;
        this.item = item;
        this.dataFlags = dataFlags;
    }

    double getX() {
        return this.x;
    }

    void setX(double x) {
        this.x = x;
    }

    double getY() {
        return this.y;
    }

    void setY(double y) {
        this.y = y;
    }

    double getZ() {
        return this.z;
    }

    void setZ(double z) {
        this.z = z;
    }

    double getYaw() {
        return this.yaw;
    }

    void setYaw(double yaw) {
        this.yaw = yaw;
    }

    double getPitch() {
        return this.pitch;
    }

    void setPitch(double pitch) {
        this.pitch = pitch;
    }

    String getLevel() {
        return this.level;
    }

    void setLevel(String level) {
        this.level = level;
    }

    String getTagName() {
        return this.tagName;
    }

    void setTagName(String tagName) {
        this.tagName = tagName;
    }

    Item getItem() {
        return this.item;
    }

    void setItem(Item item) {
        this.item = item;
    }

    long getDataFlags() {
        return this.dataFlags;
    }

    void setDataFlags(long dataFlags) {
        this.dataFlags = dataFlags;
    }
}

