/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.recording;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.scheduler.TaskHandler;
import java.util.List;
import lib.net.easecation.ghosty.entity.PlaybackNPC;
import lib.net.easecation.ghosty.recording.PlayerRecord;
import lib.net.easecation.ghosty.recording.RecordIterator;
import lib.net.easecation.ghosty.recording.RecordNode;
import lib.net.easecation.ghosty.recording.Updated;

public class PlaybackEngine {
    private final PlayerRecord record;
    private TaskHandler taskHandler;
    private Runnable onStopDo;
    private boolean playing = true;
    protected int tick = 0;
    private boolean stopped = false;
    private PlaybackNPC npc;
    private RecordIterator iterator;

    public PlaybackEngine(Plugin plugin, PlayerRecord record) {
        this(plugin, record, null, null);
    }

    public PlaybackEngine(Plugin plugin, PlayerRecord record, Level level) {
        this(plugin, record, level, null);
    }

    public PlaybackEngine(Plugin plugin, PlayerRecord record, Level level, List<Player> viewers) {
        this(plugin, record, level, viewers, null);
    }

    public PlaybackEngine(Plugin plugin, PlayerRecord record, Level level, List<Player> viewers, Skin skin) {
        this.record = record;
        this.iterator = record.iterator();
        RecordNode tick0 = this.iterator.initialValue(this.tick);
        if (level == null) {
            level = Server.getInstance().getLevelByName(tick0.getLevel());
        }
        if (level != null) {
            Location loc = new Location(tick0.getX(), tick0.getY(), tick0.getZ(), tick0.getY(), tick0.getPitch(), level);
            this.npc = new PlaybackNPC(loc, skin != null ? skin : record.getSkin(), tick0.getTagName(), viewers);
            this.npc.spawnToAll();
            this.taskHandler = Server.getInstance().getScheduler().scheduleRepeatingTask(plugin, this::onTick, 1);
            Server.getInstance().getLogger().debug(record.getPlayerName() + " PlayBack started!");
        } else {
            this.stopPlayback();
        }
    }

    public PlaybackEngine setOnStopDo(Runnable onStopDo) {
        this.onStopDo = onStopDo;
        return this;
    }

    public PlayerRecord getRecord() {
        return this.record;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void stopPlayback() {
        this.playing = false;
        this.stopped = true;
        if (this.npc != null) {
            this.npc.kill();
        }
        this.npc = null;
        this.iterator = null;
        if (this.taskHandler != null) {
            this.taskHandler.cancel();
        }
        if (this.onStopDo != null) {
            this.onStopDo.run();
        }
        Server.getInstance().getLogger().debug(this.record.getPlayerName() + " PlayBack stopped!");
    }

    public void onTick() {
        if (this.isPlaying()) {
            long now = this.iterator.peekTick();
            if (now == -1L) {
                this.stopPlayback();
                return;
            }
            if (now == (long)this.tick) {
                List<Updated> updatedList = this.iterator.peek();
                if (this.npc != null) {
                    updatedList.forEach(e -> e.processTo(this.npc));
                }
                this.iterator.pollTick();
            }
            ++this.tick;
        }
    }
}

