/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.service.NKServiceManager;
import cn.nukkit.plugin.service.RegisteredServiceProvider;
import cn.nukkit.plugin.service.ServicePriority;
import cn.nukkit.utils.Config;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class MetricsLite {
    private final ThreadFactory threadFactory = task -> new Thread(task, "bStats-Metrics");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, this.threadFactory);
    public static final int B_STATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bukkit";
    private boolean enabled;
    private static boolean logFailedRequests;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private static String serverUUID;
    private final Plugin plugin;
    private final int pluginId;

    public MetricsLite(Plugin plugin, int pluginId) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null!");
        }
        this.plugin = plugin;
        this.pluginId = pluginId;
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            plugin.getLogger().warning("Failed to load bStats config!", (Throwable)e);
        }
        if (this.enabled) {
            boolean found = false;
            for (Class service : Server.getInstance().getServiceManager().getKnownService()) {
                try {
                    service.getField("B_STATS_VERSION");
                    found = true;
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            Server.getInstance().getServiceManager().register(MetricsLite.class, (Object)this, plugin, ServicePriority.NORMAL);
            if (!found) {
                this.startSubmitting();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void startSubmitting() {
        Runnable submitTask = () -> {
            if (!this.plugin.isEnabled()) {
                this.scheduler.shutdown();
                return;
            }
            Server.getInstance().getScheduler().scheduleTask(this.plugin, this::submitData);
        };
        long initialDelay = (long)(60000.0 * (3.0 + Math.random() * 3.0));
        long secondDelay = (long)(60000.0 * (Math.random() * 30.0));
        this.scheduler.schedule(submitTask, initialDelay, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(submitTask, initialDelay + secondDelay, 1800000L, TimeUnit.MILLISECONDS);
    }

    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        String pluginName = this.plugin.getDescription().getName();
        String pluginVersion = this.plugin.getDescription().getVersion();
        data.addProperty("pluginName", pluginName);
        data.addProperty("id", (Number)this.pluginId);
        data.addProperty("pluginVersion", pluginVersion);
        data.add("customCharts", (JsonElement)new JsonArray());
        return data;
    }

    private JsonObject getServerData() {
        int playerAmount = Server.getInstance().getOnlinePlayers().size();
        int onlineMode = Server.getInstance().getPropertyBoolean("xbox-auth", (Object)true) ? 1 : 0;
        String softwareVersion = Server.getInstance().getApiVersion() + " (MC: " + Server.getInstance().getVersion().substring(1) + ")";
        String softwareName = Server.getInstance().getName();
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", serverUUID);
        data.addProperty("playerAmount", (Number)playerAmount);
        data.addProperty("onlineMode", (Number)onlineMode);
        data.addProperty("bukkitVersion", softwareVersion);
        data.addProperty("bukkitName", softwareName);
        data.addProperty("javaVersion", javaVersion);
        data.addProperty("osName", osName);
        data.addProperty("osArch", osArch);
        data.addProperty("osVersion", osVersion);
        data.addProperty("coreCount", (Number)coreCount);
        return data;
    }

    private void submitData() {
        JsonObject data = this.getServerData();
        JsonArray pluginData = new JsonArray();
        for (Class service : Server.getInstance().getServiceManager().getKnownService()) {
            try {
                List providers;
                block10: {
                    service.getField("B_STATS_VERSION");
                    providers = null;
                    try {
                        providers = Server.getInstance().getServiceManager().getRegistrations(service);
                    }
                    catch (Throwable t) {
                        try {
                            Field handle = NKServiceManager.class.getDeclaredField("handle");
                            handle.setAccessible(true);
                            providers = (List)((Map)handle.get(Server.getInstance().getServiceManager())).get(service);
                        }
                        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NullPointerException e) {
                            if (!logFailedRequests) break block10;
                            this.plugin.getLogger().error("Encountered unexpected exception ", (Throwable)e);
                        }
                    }
                }
                if (providers == null) continue;
                for (RegisteredServiceProvider provider : providers) {
                    try {
                        Object plugin = provider.getService().getMethod("getPluginData", new Class[0]).invoke(provider.getProvider(), new Object[0]);
                        if (!(plugin instanceof JsonObject)) continue;
                        pluginData.add((JsonElement)plugin);
                    }
                    catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {}
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        data.add("plugins", (JsonElement)pluginData);
        new Thread(() -> {
            block2: {
                try {
                    MetricsLite.sendData(this.plugin, data);
                }
                catch (Exception e) {
                    if (!logFailedRequests) break block2;
                    this.plugin.getLogger().warning("Could not submit plugin stats of " + this.plugin.getName(), (Throwable)e);
                }
            }
        }).start();
    }

    private void loadConfig() throws IOException {
        File bStatsFolder = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        Config config = new Config(configFile);
        if (!config.exists("serverUuid")) {
            config.set("enabled", (Object)true);
            config.set("serverUuid", (Object)UUID.randomUUID().toString());
            config.set("logFailedRequests", (Object)false);
            config.set("logSentData", (Object)false);
            config.set("logResponseStatusText", (Object)false);
            DumperOptions dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.writeFile(configFile, "# bStats collects some data for plugin authors like how many servers are using their plugins.", "# To honor their work, you should not disable it.", "# This has nearly no effect on the server performance!", "# Check out https://bStats.org/ to learn more :)", new Yaml(dumperOptions).dump((Object)config.getRootSection()));
        }
        this.enabled = config.getBoolean("enabled", true);
        serverUUID = config.getString("serverUuid");
        logFailedRequests = config.getBoolean("logFailedRequests", false);
        logSentData = config.getBoolean("logSentData", false);
        logResponseStatusText = config.getBoolean("logResponseStatusText", false);
    }

    private void writeFile(File file, String ... lines) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));){
            for (String line : lines) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
        }
    }

    private static void sendData(Plugin plugin, JsonObject data) throws Exception {
        if (data == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        if (Server.getInstance().isPrimaryThread()) {
            throw new IllegalAccessException("This method must not be called from the main thread!");
        }
        if (logSentData) {
            plugin.getLogger().info("Sending data to bStats: " + data);
        }
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = MetricsLite.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        try (DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());){
            outputStream.write(compressedData);
        }
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
        }
        if (logResponseStatusText) {
            plugin.getLogger().info("Sent data to bStats and received response: " + builder);
        }
    }

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gzip = new GZIPOutputStream(outputStream);){
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        return outputStream.toByteArray();
    }

    static {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115, 46, 110, 117, 107, 107, 105, 116});
            String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (MetricsLite.class.getPackage().getName().equals(defaultPackage) || MetricsLite.class.getPackage().getName().equals(examplePackage)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
    }
}

