/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.utils.Config;
import java.io.File;
import java.util.HashMap;
import java.util.Objects;

public class Language {
    private final Config config;

    public Language(File file) {
        this(new Config(file, 0));
    }

    public Language(File file, int type) {
        this(new Config(file, type));
    }

    public Language(Config config) {
        this.config = config;
    }

    public String translateString(String key) {
        return this.translateString(key, new Object[0]);
    }

    public String translateString(String key, Object ... params) {
        String string = this.config.getString(key, "\u00a7c Unknown key:" + key);
        if (params != null && params.length > 0) {
            for (int i = 1; i < params.length + 1; ++i) {
                string = string.replace("%" + i + "%", Objects.toString(params[i - 1]));
            }
        }
        return string;
    }

    public void update(File newFile) {
        this.update(newFile, 0);
    }

    public void update(File newFile, int type) {
        this.update(new Config(newFile, type));
    }

    public void update(Config newConfig) {
        boolean needSave = false;
        HashMap<String, String> cache = new HashMap<String, String>();
        for (String key : this.config.getKeys()) {
            if (newConfig.getKeys().contains(key)) {
                cache.put(key, this.config.getString(key, "\u00a7c Unknown key:" + key));
                continue;
            }
            this.config.remove(key);
            needSave = true;
        }
        for (String key : newConfig.getKeys()) {
            if (cache.containsKey(key)) continue;
            String string = newConfig.getString(key, "\u00a7c Unknown key:" + key);
            this.config.set(key, (Object)string);
            needSave = true;
        }
        if (needSave) {
            this.config.save();
        }
    }
}

