/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.api.Info;
import cn.nukkit.utils.Utils;
import java.io.File;
import java.io.IOException;

@Info(value="\u6587\u4ef6\u5de5\u5177\u7c7b")
public class FileUtils {
    private FileUtils() {
        throw new RuntimeException("error");
    }

    public static boolean deleteFile(String file) {
        return FileUtils.deleteFile(new File(file));
    }

    public static boolean deleteFile(File deleteFile) {
        try {
            if (!deleteFile.exists()) {
                return true;
            }
            File[] files = deleteFile.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.deleteFile(file);
                        continue;
                    }
                    if (file.delete()) continue;
                    throw new IOException("\u6587\u4ef6: " + file.getName() + " \u5220\u9664\u5931\u8d25\uff01");
                }
            }
            if (!deleteFile.delete()) {
                throw new IOException("\u6587\u4ef6: " + deleteFile.getName() + " \u5220\u9664\u5931\u8d25\uff01");
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String from, String to) {
        return FileUtils.copyDir(new File(from), new File(to));
    }

    public static boolean copyDir(String from, File to) {
        return FileUtils.copyDir(new File(from), to);
    }

    public static boolean copyDir(File from, String to) {
        return FileUtils.copyDir(from, new File(to));
    }

    public static boolean copyDir(File from, File to) {
        try {
            File[] files = from.listFiles();
            if (files != null) {
                if (!to.exists() && !to.mkdirs()) {
                    throw new IOException("\u6587\u4ef6\u5939: " + to.getName() + " \u521b\u5efa\u5931\u8d25\uff01");
                }
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.copyDir(file, new File(to, file.getName()));
                        continue;
                    }
                    Utils.copyFile((File)file, (File)new File(to, file.getName()));
                }
                return true;
            }
            Utils.copyFile((File)from, (File)to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

