/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.api.Info;
import cn.nukkit.entity.Entity;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;

public class EntityUtils {
    private static final ConcurrentHashMap<String, Number> FIELD_CACHE = new ConcurrentHashMap();

    private EntityUtils() {
        throw new RuntimeException("error");
    }

    @Info(value="\u89e3\u51b3\u591a\u7248\u672c\u517c\u5bb9\u95ee\u9898")
    public static <T extends Number> @Info(value="\u89e3\u51b3\u591a\u7248\u672c\u517c\u5bb9\u95ee\u9898") T getEntityField(String name, T defaultValue) {
        if (!FIELD_CACHE.containsKey(name)) {
            try {
                Field field = Entity.class.getDeclaredField(name);
                field.setAccessible(true);
                FIELD_CACHE.put(name, (Number)field.get(null));
            }
            catch (Exception e) {
                GameCore.getInstance().getLogger().error("\u53cd\u5c04\u83b7\u53d6\u6570\u636e\u65f6\u51fa\u73b0\u9519\u8bef\uff01", (Throwable)e);
            }
        }
        return (T)FIELD_CACHE.getOrDefault(name, defaultValue);
    }
}

