/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.ranking;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.entity.ITextFakeEntity;
import cn.lanink.gamecore.entity.TextFakeTextFakeEntity;
import cn.lanink.gamecore.ranking.RankingAPI;
import cn.lanink.gamecore.ranking.RankingFormat;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Ranking {
    private final RankingAPI rankingAPI = RankingAPI.getInstance();
    private final Plugin plugin;
    private String name;
    private Position position;
    private ITextFakeEntity entityRanking;
    private RankingFormat rankingFormat = RankingFormat.getDefaultFormat();
    private Supplier<Map<String, ? extends Number>> supplier = null;
    private final AtomicBoolean listLock = new AtomicBoolean();
    private final AtomicBoolean needSequence = new AtomicBoolean();
    private final ConcurrentHashMap<String, Number> originalList = new ConcurrentHashMap();
    private final LinkedHashMap<String, String> list = new LinkedHashMap();
    private int dataUpdateInterval = 20;
    private boolean closed = false;

    public Ranking(@NotNull Plugin plugin, @NotNull String name, @NotNull Position position) {
        this.plugin = plugin;
        this.setName(name);
        this.setPosition(position);
        this.setRankingEntity(TextFakeTextFakeEntity.class);
        this.schedulerTask();
    }

    private void schedulerTask() {
        this.rankingAPI.getUpdateTask().addRanking(this);
        this.rankingAPI.getAsyncUpdateTask().addRanking(this);
    }

    public void onTick(int i) {
        if (this.isClosed()) {
            return;
        }
        if (i % this.getDataUpdateInterval() == 0 && this.supplier != null) {
            this.setRankingList(this.supplier.get(), false);
        }
        if (this.entityRanking.needTick()) {
            this.entityRanking.onTick(i);
        }
    }

    public void onAsyncTick(int i) {
        if (this.isClosed()) {
            return;
        }
        if (this.plugin.isDisabled()) {
            this.close();
            return;
        }
        if (i % this.getDataUpdateInterval() == 0) {
            this.rearrangeList();
            this.updateShowText();
        }
        if (this.entityRanking.needAsyncTick()) {
            this.entityRanking.onAsyncTick(i);
        }
    }

    private void updateShowText() {
        if (this.listLock.get()) {
            return;
        }
        for (Player player : new HashSet<Player>(this.entityRanking.getShowTextMap().keySet())) {
            if (player.isOnline()) continue;
            this.entityRanking.getShowTextMap().remove(player);
        }
        for (Player player : Server.getInstance().getOnlinePlayers().values()) {
            StringBuilder showText = new StringBuilder(this.rankingFormat.getTop().replace("%name%", this.getName())).append("\n");
            int line = 0;
            int showLine = 1;
            double distance = this.getPosition().distance((Vector3)player);
            for (Map.Entry<Integer, Integer> entry : this.rankingFormat.getShowLine().entrySet()) {
                if (!(distance <= (double)entry.getKey().intValue())) continue;
                showLine = entry.getValue();
                break;
            }
            for (Map.Entry<Object, Object> entry : this.list.entrySet()) {
                if (++line > showLine) break;
                String lineText = player.getName().equals(entry.getKey()) ? this.rankingFormat.getLineSelf().replace("%ranking%", "" + line).replace("%player%", (CharSequence)entry.getKey()).replace("%score%", (CharSequence)entry.getValue()) : this.rankingFormat.getLine().replace("%ranking%", "" + line).replace("%player%", (CharSequence)entry.getKey()).replace("%score%", (CharSequence)entry.getValue());
                showText.append(lineText).append("\n");
            }
            showText.append(this.rankingFormat.getBottom().replace("%name%", this.getName()));
            this.entityRanking.setShowText(player, showText.toString());
        }
    }

    public void setPosition(@NotNull Position position) {
        this.position = position;
        if (this.entityRanking != null) {
            this.entityRanking.setPosition(position);
        }
    }

    public void setRankingEntity(@NotNull Class<? extends ITextFakeEntity> newEntityRanking) {
        if (this.entityRanking != null) {
            this.entityRanking.close();
        }
        try {
            this.entityRanking = newEntityRanking.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.entityRanking.setPosition(this.position);
        }
        catch (Exception e) {
            GameCore.getInstance().getLogger().error("[RankingAPI] \u521b\u5efa\u5b9e\u4f53\u65f6\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)e);
        }
    }

    public void setRankingFormat(@NotNull RankingFormat rankingFormat) {
        this.rankingFormat = rankingFormat;
    }

    public void setRankingList(@NotNull Supplier<Map<String, ? extends Number>> supplier) {
        this.supplier = supplier;
        this.setRankingList(this.supplier.get());
    }

    public synchronized void setRankingList(@NotNull Map<String, ? extends Number> newList) {
        this.setRankingList(newList, true);
    }

    public synchronized void setRankingList(@NotNull Map<String, ? extends Number> newList, boolean updateShowText) {
        this.originalList.clear();
        this.originalList.putAll(newList);
        this.needSequence.set(true);
        if (updateShowText) {
            this.rearrangeList();
            this.updateShowText();
        }
    }

    private void rearrangeList() {
        if (!this.needSequence.get() || this.listLock.get()) {
            return;
        }
        this.listLock.set(true);
        ArrayList<Map.Entry<String, Number>> arrayList = new ArrayList<Map.Entry<String, Number>>(this.originalList.entrySet());
        if (this.rankingFormat.getSortOrder() == RankingFormat.SortOrder.ASCENDING) {
            arrayList.sort((o1, o2) -> {
                if (Objects.equals(((Number)o1.getValue()).doubleValue(), ((Number)o2.getValue()).doubleValue())) {
                    return 0;
                }
                return ((Number)o1.getValue()).doubleValue() > ((Number)o2.getValue()).doubleValue() ? -1 : 1;
            });
        } else {
            arrayList.sort((o1, o2) -> {
                if (Objects.equals(((Number)o1.getValue()).doubleValue(), ((Number)o2.getValue()).doubleValue())) {
                    return 0;
                }
                return ((Number)o1.getValue()).doubleValue() > ((Number)o2.getValue()).doubleValue() ? 1 : -1;
            });
        }
        this.list.clear();
        for (Map.Entry<String, Number> entry : arrayList) {
            this.list.put(entry.getKey(), new BigDecimal(entry.getValue().toString()).toString());
        }
        this.needSequence.set(false);
        this.listLock.set(false);
    }

    public void setDataUpdateInterval(int dataUpdateInterval) {
        this.dataUpdateInterval = Math.max(dataUpdateInterval, 1);
    }

    public void clearRankingList() {
        this.list.clear();
        if (this.entityRanking != null) {
            this.entityRanking.getShowTextMap().clear();
        }
    }

    public void close() {
        this.closed = true;
        this.rankingAPI.getUpdateTask().removeRanking(this);
        this.rankingAPI.getAsyncUpdateTask().removeRanking(this);
        this.clearRankingList();
        if (this.entityRanking != null) {
            this.entityRanking.close();
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Position getPosition() {
        return this.position;
    }

    public ITextFakeEntity getEntityRanking() {
        return this.entityRanking;
    }

    public int getDataUpdateInterval() {
        return this.dataUpdateInterval;
    }

    public boolean isClosed() {
        return this.closed;
    }
}

