/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.pathfinder.astar;

import cn.lanink.gamecore.pathfinder.utils.BlockUtil;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.Position;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.ArrayList;
import java.util.List;

public class AstarNode {
    public Position position;
    public double G;
    public double H;
    public AstarNode parent;
    public Block levelBlock;

    public AstarNode(Position position, double G, double H, AstarNode parent) {
        this.position = position;
        this.G = G;
        this.H = H;
        this.parent = parent;
        this.levelBlock = position.getLevelBlock();
    }

    public void update(AstarNode node) {
        if (this.G > node.G) {
            this.position = node.position;
            this.G = node.G;
            this.H = node.H;
            this.parent = node.parent;
            this.levelBlock = this.position.getLevelBlock();
        }
    }

    public CompoundTag getDefaultNBT(Position pos) {
        return Entity.getDefaultNBT((Vector3)pos).putCompound("Skin", new CompoundTag());
    }

    public double getF(double power) {
        return (1.0 - power) * this.G + power * this.H;
    }

    public List<AstarNode> getNextAccessibleNodes(Position target) {
        ArrayList<AstarNode> nodes = new ArrayList<AstarNode>();
        for (int[] motion : BlockUtil.MOTION) {
            Position nextStep = this.position.add((double)motion[0], (double)motion[1], (double)motion[2]);
            if (!this.isAccessible(motion, this, nextStep)) continue;
            AstarNode nextNode = new AstarNode(nextStep, this.G + this.getAddG(motion), BlockUtil.MHDistance((Vector3)nextStep, (Vector3)target), this);
            nodes.add(nextNode);
        }
        return nodes;
    }

    private double getAddG(int[] direct) {
        int count = 0;
        for (int val : direct) {
            if (val == 0) continue;
            ++count;
        }
        switch (count) {
            case 1: {
                return 1.0;
            }
            case 2: {
                return 1.4142;
            }
            case 3: {
                return 1.732;
            }
        }
        return 0.0;
    }

    public boolean isAccessible(int[] selectedMotion, AstarNode selectedNode, Position nextPos) {
        if (!BlockUtil.isPermeable(nextPos.getLevelBlock()) || !BlockUtil.isPermeable(BlockUtil.getNearBlock(nextPos.getLevelBlock(), BlockFace.UP))) {
            return false;
        }
        if (selectedMotion[1] == 1 && !BlockUtil.checkUpAccessed(selectedNode.levelBlock)) {
            return false;
        }
        if (!(selectedMotion[0] == 0 && selectedMotion[2] == 0 || selectedMotion[1] != 0 || BlockUtil.canStand(BlockUtil.getNearBlock(selectedNode.levelBlock, BlockFace.DOWN)))) {
            return !BlockUtil.isPermeable(BlockUtil.getNearBlock(selectedNode.levelBlock.getLevel().getBlock((Vector3)nextPos), BlockFace.DOWN));
        }
        if ((selectedMotion[0] != 0 || selectedMotion[2] != 0) && selectedMotion[1] == -1) {
            return false;
        }
        if (selectedMotion[0] != 0 && selectedMotion[2] != 0 && selectedMotion[1] != 0) {
            return BlockUtil.isPermeable(selectedNode.position.getLevel().getBlock((Vector3)selectedNode.position.add((double)selectedMotion[0], (double)selectedMotion[1]))) && BlockUtil.isPermeable(selectedNode.position.getLevel().getBlock((Vector3)selectedNode.position.add(0.0, (double)selectedMotion[1], (double)selectedMotion[2])));
        }
        return selectedMotion[0] == 0 || selectedMotion[2] == 0 || !BlockUtil.isPermeable(selectedNode.position.getLevel().getBlock((Vector3)selectedNode.position.add((double)selectedMotion[0]))) || !BlockUtil.isPermeable(selectedNode.position.getLevel().getBlock((Vector3)selectedNode.position.add(0.0, 0.0, (double)selectedMotion[2])));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AstarNode) {
            AstarNode node = (AstarNode)obj;
            return node.levelBlock.equals((Object)this.levelBlock);
        }
        return false;
    }

    public int hashCode() {
        return this.levelBlock.hashCode();
    }

    public boolean equals(Position loc) {
        return loc.getLevelBlock().equals((Object)this.levelBlock);
    }
}

