/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.pathfinder;

import cn.lanink.gamecore.pathfinder.api.PathFinder;
import cn.lanink.gamecore.pathfinder.astar.AstarPathFinder;
import cn.nukkit.level.Position;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class PathFinderUtil {
    public static final FinderType DEFAULT_FINDER_TYPE = FinderType.ASTAR;

    public static PathFinder quickPathBuild(@NotNull Position start, @NotNull Position target) {
        return PathFinderUtil.quickPathBuild(null, start, target);
    }

    public static PathFinder quickPathBuild(FinderType type, @NotNull Position start, @NotNull Position target) {
        Objects.requireNonNull(start, "null parameter given!");
        Objects.requireNonNull(target, "null parameter given!");
        if (type == null) {
            return PathFinderUtil.quickPathBuild(DEFAULT_FINDER_TYPE, start, target);
        }
        switch (type) {
            default: 
        }
        return new AstarPathFinder(start, target);
    }

    public static Builder builder(FinderType type) {
        switch (type) {
            default: 
        }
        return new AstarPathBuilder();
    }

    public static enum FinderType {
        ASTAR;

    }

    public static class AstarPathBuilder
    extends Builder {
        private double power = 0.5;
        private int timeLimit = 100;
        private Position start;
        private Position target;

        public AstarPathBuilder start(Position start) {
            this.start = start;
            return this;
        }

        public AstarPathBuilder target(Position target) {
            this.target = target;
            return this;
        }

        public AstarPathBuilder timeLimit(int timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public AstarPathBuilder power(double power) {
            this.power = power;
            return this;
        }

        @Override
        public AstarPathFinder build() {
            return new AstarPathFinder(this.start, this.target, this.timeLimit, this.power);
        }
    }

    public static abstract class Builder {
        abstract PathFinder build();
    }
}

