/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.hotswap.load;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.hotswap.ModuleBase;
import cn.lanink.gamecore.hotswap.load.ModuleClassLoader;
import cn.lanink.gamecore.utils.Download;
import cn.nukkit.Server;
import cn.nukkit.plugin.JavaPluginLoader;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginClassLoader;
import cn.nukkit.plugin.PluginDescription;
import cn.nukkit.plugin.PluginManager;
import cn.nukkit.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.NonNull;

public class ModuleLoader {
    private final Plugin plugin;
    private final Server server;
    private final Map<String, Class<?>> classes = new HashMap();
    private final Map<String, ModuleClassLoader> classLoaders = new HashMap<String, ModuleClassLoader>();
    private final ConcurrentHashMap<String, ModuleBase> loadedModules = new ConcurrentHashMap();

    public ModuleLoader() {
        throw new RuntimeException("error!");
    }

    public ModuleLoader(Plugin plugin) {
        this.plugin = plugin;
        this.server = plugin.getServer();
    }

    public void enabledModules() {
        this.loadedModules.values().forEach(moduleBase -> moduleBase.setEnabled(true));
    }

    public void loadModuleFromWebUrl(String url, String folder, String moduleName) {
        File saveFile = new File(this.plugin.getDataFolder() + "/" + folder, moduleName + ".jar");
        saveFile.getParentFile().mkdirs();
        boolean checked = Download.download(url, saveFile, this::loadModule);
        if (!checked) {
            this.plugin.getLogger().info(moduleName + ".jar had already downloaded");
        }
    }

    public void loadModuleFromWebUrl(String url, File saveTo) {
        saveTo.getParentFile().mkdirs();
        boolean checked = Download.download(url, saveTo, this::loadModule);
        if (!checked) {
            this.plugin.getLogger().info(saveTo.getName() + " had already downloaded");
        }
    }

    public ModuleBase loadModuleWithDefault(String moduleName) {
        return this.loadModule(new File(this.plugin.getDataFolder() + "/modules/" + moduleName + ".jar"));
    }

    public ModuleBase loadModuleFromModuleFolderAndModuleName(String folder, String moduleName) {
        return this.loadModule(new File(this.plugin.getDataFolder() + "/" + folder + "/" + moduleName + ".jar"));
    }

    public ModuleBase loadModule(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try {
            ModuleClassLoader classLoader;
            PluginDescription description = this.getModuleDescription(file);
            if (description == null) {
                throw new RuntimeException(file.getName() + " module.yml or plugin.yml not found!");
            }
            String className = description.getMain();
            try {
                classLoader = new ModuleClassLoader(this, this.getClass().getClassLoader(), file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(description.getName() + " ClassLoader get failed!");
            }
            this.classLoaders.put(description.getName(), classLoader);
            try {
                PluginClassLoader injectPluginClassLoader = new PluginClassLoader((JavaPluginLoader)GameCore.getInstance().getPluginLoader(), (ClassLoader)classLoader, file);
                Field loadersF = PluginManager.class.getDeclaredField("fileAssociations");
                loadersF.setAccessible(true);
                Map loaders = (Map)loadersF.get(Server.getInstance().getPluginManager());
                Field classLoadersF = JavaPluginLoader.class.getDeclaredField("classLoaders");
                classLoadersF.setAccessible(true);
                for (Map.Entry entry : loaders.entrySet()) {
                    if (!(entry.getValue() instanceof JavaPluginLoader)) continue;
                    Map cls = (Map)classLoadersF.get(entry.getValue());
                    cls.put(description.getName(), injectPluginClassLoader);
                    classLoadersF.set(entry.getValue(), cls);
                }
            }
            catch (Exception ignored) {
                GameCore.getInstance().getLogger().warning("\u00a7c try to inject module " + description.getName() + " into nukkit plugin class loaders failed!");
                GameCore.getInstance().getLogger().warning("\u00a7c plugins in the outside may not be able to depend on this module");
            }
            try {
                Class<?> javaClass = classLoader.loadClass(className);
                if (!ModuleBase.class.isAssignableFrom(javaClass)) {
                    throw new RuntimeException("Main class `" + description.getMain() + "' does not extend Module");
                }
                try {
                    Class<ModuleBase> pluginClass = javaClass.asSubclass(ModuleBase.class);
                    ModuleBase module = pluginClass.newInstance();
                    this.initModule(module, description, file);
                    this.loadedModules.put(module.getName(), module);
                    return module;
                }
                catch (ClassCastException e) {
                    throw new RuntimeException(description.getName() + " Error whilst initializing main class");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(description.getName() + " load failed case: unknow reason");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(description.getName() + " main class not found");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PluginDescription getModuleDescription(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (JarFile jar = new JarFile(file);){
            PluginDescription pluginDescription;
            block17: {
                JarEntry entry = jar.getJarEntry("module.yml");
                if (entry == null) {
                    entry = jar.getJarEntry("plugin.yml");
                }
                if (entry == null) {
                    PluginDescription pluginDescription2 = null;
                    return pluginDescription2;
                }
                InputStream stream = jar.getInputStream(entry);
                try {
                    pluginDescription = new PluginDescription(Utils.readFile((InputStream)stream));
                    if (stream == null) break block17;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return pluginDescription;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void initModule(ModuleBase module, PluginDescription description, File file) {
        module.init(Server.getInstance(), description, file, this.plugin);
    }

    public static void enableModule(ModuleBase module) {
        if (module != null && !module.isEnabled()) {
            module.setEnabled(true);
        }
    }

    public static void disableModule(ModuleBase module) {
        if (module != null && module.isEnabled()) {
            module.setEnabled(false);
        }
    }

    Class<?> getClassByName(String name) {
        Class<?> cachedClass = this.classes.get(name);
        if (cachedClass != null) {
            return cachedClass;
        }
        for (ModuleClassLoader loader : this.classLoaders.values()) {
            try {
                cachedClass = loader.findClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (cachedClass == null) continue;
            return cachedClass;
        }
        return null;
    }

    void setClass(String name, Class<?> clazz) {
        if (!this.classes.containsKey(name)) {
            this.classes.put(name, clazz);
        }
    }

    public ConcurrentHashMap<String, ModuleBase> getLoadedModules() {
        return this.loadedModules;
    }
}

