/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.v1.recording;

import cn.nukkit.level.Location;
import cn.nukkit.utils.BinaryStream;
import lib.net.easecation.ghosty.v1.entity.PlaybackNPC;
import lib.net.easecation.ghosty.v1.recording.RecordNode;
import lib.net.easecation.ghosty.v1.recording.Updated;

class UpdatedRotation
implements Updated {
    private double yaw;
    private double pitch;

    @Override
    public void processTo(PlaybackNPC ghost) {
        Location location = ghost.getLocation();
        location.yaw = this.yaw;
        location.pitch = this.pitch;
        ghost.teleport(location);
    }

    @Override
    public RecordNode applyTo(RecordNode node) {
        node.setYaw(this.yaw);
        node.setPitch(this.pitch);
        return node;
    }

    static UpdatedRotation of(double yaw, double pitch) {
        return new UpdatedRotation(yaw, pitch);
    }

    @Override
    public int getUpdateTypeId() {
        return 1;
    }

    public UpdatedRotation(BinaryStream stream) {
        this.read(stream);
    }

    private UpdatedRotation(double yaw, double pitch) {
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UpdatedRotation)) {
            return false;
        }
        UpdatedRotation o = (UpdatedRotation)obj;
        return this.yaw == o.yaw && this.pitch == o.pitch;
    }

    @Override
    public void write(BinaryStream stream) {
        stream.putFloat((float)this.yaw);
        stream.putFloat((float)this.pitch);
    }

    @Override
    public void read(BinaryStream stream) {
        this.yaw = stream.getFloat();
        this.pitch = stream.getFloat();
    }
}

