/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.v1;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class MathUtil {
    public static int getMax(int ... nums) {
        Objects.requireNonNull(nums);
        boolean hasMax = false;
        int max = 0;
        for (int num : nums) {
            if (hasMax && num <= max) continue;
            max = num;
            hasMax = true;
        }
        return max;
    }

    public static int getMin(int ... nums) {
        Objects.requireNonNull(nums);
        boolean hasMin = false;
        int min = 0;
        for (int num : nums) {
            if (hasMin && num >= min) continue;
            min = num;
            hasMin = true;
        }
        return min;
    }

    public static int getSecondTimestamp() {
        return MathUtil.getSecondTimestamp(System.currentTimeMillis());
    }

    public static int getSecondTimestamp(long time) {
        String timestamp = String.valueOf(time);
        int length = timestamp.length();
        if (length > 3) {
            return Integer.parseInt(timestamp.substring(0, length - 3));
        }
        return 0;
    }

    public static String getTimestampString(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(time));
    }

    public static String getSecondTimestampString(int sceondTimestamp) {
        return MathUtil.getTimestampString((long)sceondTimestamp * 1000L);
    }

    public static int getDateSpace(Date time1, Date time2) {
        Calendar calst = Calendar.getInstance();
        Calendar caled = Calendar.getInstance();
        calst.setTime(time1);
        caled.setTime(time2);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        return Math.abs(((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24);
    }

    public static double getSum(double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        double sum = 0.0;
        for (double inputDatum : inputData) {
            sum += inputDatum;
        }
        return sum;
    }

    public static int getCount(double[] inputData) {
        if (inputData == null) {
            return -1;
        }
        return inputData.length;
    }

    public static double getAverage(double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        int len = inputData.length;
        double result = MathUtil.getSum(inputData) / (double)len;
        return result;
    }

    public static double getSquareSum(double[] inputData) {
        if (inputData == null || inputData.length == 0) {
            return -1.0;
        }
        double sqrsum = 0.0;
        for (double inputDatum : inputData) {
            sqrsum += inputDatum * inputDatum;
        }
        return sqrsum;
    }

    public static double getVariance(double[] inputData) {
        int count = MathUtil.getCount(inputData);
        double sqrsum = MathUtil.getSquareSum(inputData);
        double average = MathUtil.getAverage(inputData);
        double result = (sqrsum - (double)count * average * average) / (double)count;
        return result;
    }

    public static double getStandardDiviation(double[] inputData) {
        double result = Math.sqrt(Math.abs(MathUtil.getVariance(inputData)));
        return result;
    }
}

