/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.ranking.task;

import cn.lanink.gamecore.ranking.Ranking;
import cn.lanink.gamecore.ranking.RankingAPI;
import cn.lanink.gamecore.ranking.task.IRankingAPITask;
import cn.nukkit.scheduler.AsyncTask;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class AsyncUpdateTask
extends AsyncTask
implements IRankingAPITask {
    private int tick = 0;
    private final Set<Ranking> updateRankings = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public Set<Ranking> getRankings() {
        return this.updateRankings;
    }

    @Override
    public boolean addRanking(@NotNull Ranking ranking) {
        return this.updateRankings.add(ranking);
    }

    @Override
    public void removeRanking(@NotNull Ranking ranking) {
        this.updateRankings.remove(ranking);
    }

    public void onRun() {
        while (RankingAPI.getInstance().isEnabled()) {
            long startTime = System.currentTimeMillis();
            try {
                this.work(this.tick);
            }
            catch (Exception e) {
                RankingAPI.getInstance().getLogger().error("AsyncUpdateTask\u904d\u5386Ranking\u65f6\u51fa\u9519\uff1a", (Throwable)e);
            }
            long duration = System.currentTimeMillis() - startTime;
            try {
                Thread.sleep(Math.max(50L - duration, 1L));
            }
            catch (Exception e) {
                RankingAPI.getInstance().getLogger().error("AsyncUpdateTask\u5c1d\u8bd5\u4f11\u7720\u65f6\u51fa\u9519\uff1a", (Throwable)e);
            }
            ++this.tick;
        }
        for (Ranking ranking : new HashSet<Ranking>(this.updateRankings)) {
            ranking.close();
        }
    }

    private void work(int tick) {
        for (Ranking ranking : this.updateRankings) {
            ranking.onAsyncTick(tick);
        }
    }
}

