/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.ranking;

import cn.lanink.gamecore.GameCore;
import cn.lanink.gamecore.ranking.Ranking;
import cn.lanink.gamecore.ranking.task.AsyncUpdateTask;
import cn.lanink.gamecore.ranking.task.UpdateTask;
import cn.nukkit.level.Position;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginLogger;
import cn.nukkit.scheduler.AsyncTask;
import org.jetbrains.annotations.NotNull;

public class RankingAPI {
    private static RankingAPI rankingAPI;
    private boolean isEnabled;
    private AsyncUpdateTask asyncUpdateTask;
    private UpdateTask updateTask;

    public static RankingAPI getInstance() {
        return rankingAPI;
    }

    public void onLoad() {
        rankingAPI = this;
    }

    public void onEnable() {
        this.asyncUpdateTask = new AsyncUpdateTask();
        GameCore.getInstance().getServer().getScheduler().scheduleAsyncTask((Plugin)GameCore.getInstance(), (AsyncTask)this.asyncUpdateTask);
        this.updateTask = new UpdateTask();
        GameCore.getInstance().getServer().getScheduler().scheduleRepeatingTask((Plugin)GameCore.getInstance(), (Runnable)((Object)this.updateTask), 1);
        this.isEnabled = true;
    }

    public void onDisable() {
        for (Ranking ranking : this.asyncUpdateTask.getRankings()) {
            ranking.close();
        }
        for (Ranking ranking : this.updateTask.getRankings()) {
            ranking.close();
        }
    }

    public static Ranking createRanking(@NotNull Plugin plugin, @NotNull String name, @NotNull Position position) {
        return new Ranking(plugin, name, position);
    }

    public PluginLogger getLogger() {
        return GameCore.getInstance().getLogger();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public AsyncUpdateTask getAsyncUpdateTask() {
        return this.asyncUpdateTask;
    }

    public UpdateTask getUpdateTask() {
        return this.updateTask;
    }
}

