/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.form.inventory.responsible;

import cn.nukkit.Player;
import cn.nukkit.event.inventory.InventoryClickEvent;
import cn.nukkit.item.Item;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public abstract class ResponseItem {
    private final Item item;
    private BiConsumer<InventoryClickEvent, Player> clickItemListener;

    public ResponseItem(@NotNull Item item) {
        this.item = item;
    }

    public ResponseItem onClick(@NotNull BiConsumer<InventoryClickEvent, Player> listener) {
        this.clickItemListener = listener;
        return this;
    }

    public void callClick(@NotNull InventoryClickEvent event, @NotNull Player player) {
        this.clickItemListener.accept(event, player);
    }

    public Item getItem() {
        return this.item.clone();
    }

    public BiConsumer<InventoryClickEvent, Player> getClickItemListener() {
        return this.clickItemListener;
    }

    public void setClickItemListener(BiConsumer<InventoryClickEvent, Player> clickItemListener) {
        this.clickItemListener = clickItemListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseItem)) {
            return false;
        }
        ResponseItem other = (ResponseItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Item this$item = this.getItem();
        Item other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        BiConsumer<InventoryClickEvent, Player> this$clickItemListener = this.getClickItemListener();
        BiConsumer<InventoryClickEvent, Player> other$clickItemListener = other.getClickItemListener();
        return !(this$clickItemListener == null ? other$clickItemListener != null : !this$clickItemListener.equals(other$clickItemListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Item $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        BiConsumer<InventoryClickEvent, Player> $clickItemListener = this.getClickItemListener();
        result = result * 59 + ($clickItemListener == null ? 43 : $clickItemListener.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseItem(item=" + this.getItem() + ", clickItemListener=" + this.getClickItemListener() + ")";
    }
}

