/*
 * Decompiled with CFR 0.152.
 */
package lib.net.easecation.ghosty.v1.recording;

import cn.nukkit.entity.data.Skin;
import cn.nukkit.utils.BinaryStream;
import java.util.Base64;
import lib.net.easecation.ghosty.v1.recording.LmlPlayerRecord;
import lib.net.easecation.ghosty.v1.recording.RecordIterator;
import lib.net.easecation.ghosty.v1.recording.RecordNode;

public interface PlayerRecord {
    public static final byte OBJECT_LML = 0;

    public void record(long var1, RecordNode var3);

    public RecordIterator iterator();

    public String getPlayerName();

    public Skin getSkin();

    default public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.toBinary());
    }

    public byte[] toBinary();

    public static PlayerRecord fromBase64String(String string) {
        return PlayerRecord.fromBinary(Base64.getDecoder().decode(string));
    }

    public static PlayerRecord fromBinary(byte[] data) {
        BinaryStream stream = new BinaryStream(data);
        byte type = (byte)stream.getByte();
        if (type == 0) {
            return new LmlPlayerRecord(stream);
        }
        return null;
    }
}

