/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.nukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class VersionUtils {
    public static boolean checkMinimumVersion(@NotNull Plugin plugin, @NotNull String leastVersion) {
        return VersionUtils.compareVersion(plugin.getDescription().getVersion(), leastVersion) != -1;
    }

    public static int compareVersion(@NotNull String v1, @NotNull String v2) {
        if (v1.equalsIgnoreCase(v2)) {
            return 0;
        }
        String[] version1Array = v1.split("[._]");
        String[] version2Array = v2.split("[._]");
        int minLen = Math.min(version1Array.length, version2Array.length);
        long diff = 0L;
        for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array[index]) - Long.parseLong(version2Array[index])) == 0L; ++index) {
        }
        if (diff == 0L) {
            int i;
            for (i = index; i < version1Array.length; ++i) {
                if (Long.parseLong(version1Array[i]) <= 0L) continue;
                return 1;
            }
            for (i = index; i < version2Array.length; ++i) {
                if (Long.parseLong(version2Array[i]) <= 0L) continue;
                return -1;
            }
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }
}

