/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.utils;

import cn.lanink.gamecore.api.Info;
import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.item.Item;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.Config;
import java.io.File;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Info(value="\u73a9\u5bb6\u6570\u636e\u5de5\u5177\u7c7b - \u80cc\u5305\u4fdd\u5b58 \u672b\u5f71\u7bb1\u4fdd\u5b58 \u9965\u997f\u503c \u6e38\u620f\u6a21\u5f0f \u73a9\u5bb6\u4f4d\u7f6e")
public class PlayerDataUtils {
    private PlayerDataUtils() {
        throw new RuntimeException("error");
    }

    public static PlayerData create(@NotNull Player player) {
        return new PlayerData(player);
    }

    public static PlayerData create(@NotNull Player player, @NotNull Plugin plugin) {
        return PlayerDataUtils.create(player, new File(plugin.getDataFolder() + "/PlayerStatusData/" + player.getName() + ".json"));
    }

    public static PlayerData create(@NotNull Player player, @NotNull File file) {
        return PlayerDataUtils.create(player, new Config(file, 1));
    }

    public static PlayerData create(@NotNull Player player, @NotNull Config config) {
        return new PlayerData(player, config);
    }

    public static LinkedHashMap<String, List<?>> inventoryToLinkedHashMap(@NotNull Map<Integer, Item> inventoryContents) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i = 0; i < inventoryContents.size(); ++i) {
            Item item = inventoryContents.get(i);
            LinkedList<String> list = new LinkedList<String>();
            if (item != null) {
                list.add(item.getId() + ":" + item.getDamage());
                list.add(String.valueOf(item.getCount()));
                list.add(PlayerDataUtils.bytesToBase64(item.getCompoundTag()));
            }
            linkedHashMap.put(i + "", list);
        }
        return linkedHashMap;
    }

    public static Map<Integer, Item> linkedHashMapToInventory(Map<String, List<?>> inventory) {
        if (inventory == null || inventory.isEmpty()) {
            return new HashMap<Integer, Item>();
        }
        LinkedHashMap<Integer, Item> map = new LinkedHashMap<Integer, Item>();
        for (Map.Entry<String, List<?>> entry : inventory.entrySet()) {
            List<?> list = null;
            try {
                list = entry.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null || list.isEmpty()) continue;
            Item item = Item.fromString((String)((String)list.get(0)));
            item.setCount(Integer.parseInt((String)list.get(1)));
            if (!"not".equals(String.valueOf(list.get(2)))) {
                item.setNamedTag(Item.parseCompoundTag((byte[])PlayerDataUtils.base64ToBytes((String)list.get(2))));
            }
            map.put(Integer.parseInt(entry.getKey()), item);
        }
        return map;
    }

    public static String bytesToBase64(byte[] src) {
        if (src == null || src.length <= 0) {
            return "not";
        }
        return Base64.getEncoder().encodeToString(src);
    }

    public static byte[] base64ToBytes(String hexString) {
        if (hexString == null || "".equals(hexString)) {
            return null;
        }
        return Base64.getDecoder().decode(hexString);
    }

    public static Map<String, Object> positionToMap(Position position) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("x", position.x);
        map.put("y", position.y);
        map.put("z", position.z);
        map.put("level", position.level.getFolderName());
        return map;
    }

    public static Position mapToPosition(Map<String, Object> map) {
        Position position = new Position(((Double)map.getOrDefault("x", 0.0)).doubleValue(), ((Double)map.getOrDefault("y", 0.0)).doubleValue(), ((Double)map.getOrDefault("z", 0.0)).doubleValue(), Server.getInstance().getLevelByName((String)map.getOrDefault("level", "world")));
        return position.isValid() ? position : null;
    }

    public static class PlayerData {
        private final Player player;
        private Map<Integer, Item> inventoryContents = null;
        private Map<Integer, Item> offhandInventoryContents = null;
        private Map<Integer, Item> enderChestContents = null;
        private int foodLevel = -1;
        private float foodSaturationLevel = -1.0f;
        private int gameMode = -1;
        private Position position = null;

        private PlayerData(@NotNull Player player) {
            this.player = player;
        }

        private PlayerData(@NotNull Player player, @NotNull Config config) {
            this(player);
            if (config.exists("inventoryContents")) {
                this.inventoryContents = PlayerDataUtils.linkedHashMapToInventory((Map)config.get("inventoryContents", new HashMap()));
            }
            if (config.exists("offhandInventoryContents")) {
                this.offhandInventoryContents = PlayerDataUtils.linkedHashMapToInventory((Map)config.get("offhandInventoryContents", new HashMap()));
            }
            if (config.exists("enderChestContents")) {
                this.enderChestContents = PlayerDataUtils.linkedHashMapToInventory((Map)config.get("enderChestContents", new HashMap()));
            }
            if (config.exists("foodLevel")) {
                this.foodLevel = config.getInt("foodLevel", -1);
                this.foodSaturationLevel = (float)config.getDouble("foodSaturationLevel", -1.0);
            }
            if (config.exists("gameMode")) {
                this.gameMode = config.getInt("gameMode", -1);
            }
            if (config.exists("position")) {
                this.position = PlayerDataUtils.mapToPosition((Map)config.get("position", new HashMap()));
            }
        }

        public PlayerData saveAll() {
            this.saveInventory();
            this.saveEnderChestInventory();
            this.saveFoodData();
            this.saveGameMode();
            this.savePosition();
            return this;
        }

        public PlayerData restoreAll() {
            this.restoreInventory();
            this.restoreEnderChestInventory();
            this.restoreFoodData();
            this.restoreGameMode();
            this.restorePosition();
            return this;
        }

        public PlayerData saveInventory() {
            this.inventoryContents = this.player.getInventory().getContents();
            this.offhandInventoryContents = this.player.getOffhandInventory().getContents();
            return this;
        }

        public PlayerData restoreInventory() {
            if (this.inventoryContents != null) {
                this.player.getInventory().setContents(this.inventoryContents);
            }
            if (this.offhandInventoryContents != null) {
                this.player.getOffhandInventory().setContents(this.offhandInventoryContents);
            }
            return this;
        }

        public PlayerData saveEnderChestInventory() {
            this.enderChestContents = this.player.getEnderChestInventory().getContents();
            return this;
        }

        public PlayerData restoreEnderChestInventory() {
            if (this.enderChestContents != null) {
                this.player.getEnderChestInventory().setContents(this.enderChestContents);
            }
            return this;
        }

        public PlayerData saveFoodData() {
            this.foodLevel = this.player.getFoodData().getLevel();
            this.foodSaturationLevel = this.player.getFoodData().getFoodSaturationLevel();
            return this;
        }

        public PlayerData restoreFoodData() {
            if (this.foodLevel >= 0) {
                this.player.getFoodData().setLevel(this.foodLevel, this.foodSaturationLevel);
            }
            return this;
        }

        public PlayerData saveGameMode() {
            this.gameMode = this.player.getGamemode();
            return this;
        }

        public PlayerData restoreGameMode() {
            if (this.gameMode > 0) {
                this.player.setGamemode(this.gameMode);
            }
            return this;
        }

        public PlayerData savePosition() {
            this.position = this.player.getPosition();
            return this;
        }

        public PlayerData restorePosition() {
            if (this.position != null) {
                this.player.teleport(this.position, null);
                this.player.setPosition((Vector3)this.position);
            }
            return this;
        }

        public PlayerData saveToFile(Plugin plugin) {
            return this.saveToFile(new File(plugin.getDataFolder() + "/PlayerStatusData/" + this.player.getName() + ".json"));
        }

        public PlayerData saveToFile(File file) {
            return this.saveToFile(new Config(file, 1));
        }

        public PlayerData saveToFile(Config config) {
            if (this.inventoryContents != null) {
                config.set("inventoryContents", PlayerDataUtils.inventoryToLinkedHashMap(this.inventoryContents));
            }
            if (this.offhandInventoryContents != null) {
                config.set("offhandInventoryContents", PlayerDataUtils.inventoryToLinkedHashMap(this.offhandInventoryContents));
            }
            if (this.enderChestContents != null) {
                config.set("enderChestContents", PlayerDataUtils.inventoryToLinkedHashMap(this.enderChestContents));
            }
            if (this.foodLevel >= 0) {
                config.set("foodLevel", (Object)this.foodLevel);
                config.set("foodSaturationLevel", (Object)Float.valueOf(this.foodSaturationLevel));
            }
            if (this.gameMode >= 0) {
                config.set("gameMode", (Object)this.gameMode);
            }
            if (this.position != null) {
                config.set("position", PlayerDataUtils.positionToMap(this.position));
            }
            config.save();
            return this;
        }
    }
}

