/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.listener;

import cn.lanink.gamecore.listener.IGameListener;
import cn.lanink.gamecore.room.IRoom;
import cn.lanink.gamecore.utils.exception.GameListenerInitException;
import cn.nukkit.level.Level;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseGameListener<T extends IRoom>
implements IGameListener<T> {
    private String listenerName = null;
    private final ConcurrentHashMap<String, T> listenerRooms = new ConcurrentHashMap();

    @Override
    public final void init(String listenerName) throws GameListenerInitException {
        if (this.listenerName == null) {
            if (listenerName == null || listenerName.trim().isEmpty()) {
                throw new GameListenerInitException("\u7a7a\u53c2\u6570");
            }
        } else {
            throw new GameListenerInitException("\u91cd\u590d\u521d\u59cb\u5316");
        }
        this.listenerName = listenerName;
    }

    @Override
    public String getListenerName() {
        return this.listenerName;
    }

    @Override
    public Map<String, T> getListenerRooms() {
        return this.listenerRooms;
    }

    public T getListenerRoom(Level level) {
        return this.getListenerRoom(level.getFolderName());
    }

    @Override
    public T getListenerRoom(String level) {
        return (T)((IRoom)this.listenerRooms.get(level));
    }

    @Override
    public void addListenerRoom(T room) {
        this.listenerRooms.put(room.getLevelName(), room);
    }

    @Override
    public void removeListenerRoom(T room) {
        this.removeListenerRoom(room.getLevelName());
    }

    @Override
    public void removeListenerRoom(String level) {
        this.listenerRooms.remove(level);
    }

    @Override
    public void clearListenerRooms() {
        this.listenerRooms.clear();
    }
}

