/*
 * Decompiled with CFR 0.152.
 */
package cn.lanink.gamecore.hotswap;

import cn.lanink.gamecore.hotswap.ModuleBase;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.LogLevel;
import cn.nukkit.utils.Logger;
import lombok.NonNull;

public class ModuleLogger
implements Logger {
    private final ModuleBase module;
    private final String prefix;
    private final Plugin parent;

    public ModuleLogger(@NonNull ModuleBase module, @NonNull Plugin parentPlugin) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (parentPlugin == null) {
            throw new NullPointerException("parentPlugin is marked non-null but is null");
        }
        this.module = module;
        this.parent = parentPlugin;
        this.prefix = "[" + module.getName() + "]";
    }

    public ModuleBase getModule() {
        return this.module;
    }

    public void emergency(String s) {
        this.parent.getLogger().emergency(this.prefix + ": " + s);
    }

    public void alert(String s) {
        this.parent.getLogger().alert(this.prefix + ": " + s);
    }

    public void critical(String s) {
        this.parent.getLogger().critical(this.prefix + ": " + s);
    }

    public void error(String s) {
        this.parent.getLogger().error(this.prefix + ": " + s);
    }

    public void warning(String s) {
        this.parent.getLogger().warning(this.prefix + ": " + s);
    }

    public void notice(String s) {
        this.parent.getLogger().notice(this.prefix + ": " + s);
    }

    public void info(String s) {
        this.parent.getLogger().info(this.prefix + ": " + s);
    }

    public void debug(String s) {
        this.parent.getLogger().debug(this.prefix + ": " + s);
    }

    public void log(LogLevel logLevel, String s) {
        this.parent.getLogger().log(logLevel, this.prefix + ": " + s);
    }

    public void emergency(String s, Throwable throwable) {
        this.parent.getLogger().emergency(this.prefix + ": " + s, throwable);
    }

    public void alert(String s, Throwable throwable) {
        this.parent.getLogger().alert(this.prefix + ": " + s, throwable);
    }

    public void critical(String s, Throwable throwable) {
        this.parent.getLogger().critical(this.prefix + ": " + s, throwable);
    }

    public void error(String s, Throwable throwable) {
        this.parent.getLogger().error(this.prefix + ": " + s, throwable);
    }

    public void warning(String s, Throwable throwable) {
        this.parent.getLogger().warning(this.prefix + ": " + s, throwable);
    }

    public void notice(String s, Throwable throwable) {
        this.parent.getLogger().notice(this.prefix + ": " + s, throwable);
    }

    public void info(String s, Throwable throwable) {
        this.parent.getLogger().info(this.prefix + ": " + s, throwable);
    }

    public void debug(String s, Throwable throwable) {
        this.parent.getLogger().debug(this.prefix + ": " + s, throwable);
    }

    public void log(LogLevel logLevel, String s, Throwable throwable) {
        this.parent.getLogger().log(logLevel, this.prefix + ": " + s, throwable);
    }
}

