/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.config;

import cn.langpy.simsearch.config.SimSearchConfig;
import cn.langpy.simsearch.util.IndexManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class IndexConfig {
    @Autowired
    private SimSearchConfig searchConfig;
    public static Logger log = Logger.getLogger(IndexConfig.class.toString());
    private static final String defaultIndexDirName = "indexs";

    @Bean
    public Directory directory() throws IOException {
        BaseDirectory directory = null;
        if ("memory".equals(this.searchConfig.getSaver())) {
            directory = new ByteBuffersDirectory();
        } else if ("memory-fs".equals(this.searchConfig.getSaver())) {
            Path path = Paths.get(this.checkDir(), new String[0]);
            directory = MMapDirectory.open(path);
        } else if ("base-fs".equals(this.searchConfig.getSaver())) {
            Path path = Paths.get(this.checkDir(), new String[0]);
            directory = FSDirectory.open(path);
        } else if ("nio-fs".equals(this.searchConfig.getSaver())) {
            Path path = Paths.get(this.checkDir(), new String[0]);
            directory = NIOFSDirectory.open(path);
        } else {
            throw new RuntimeException("error `sim-search.saver`,please choice in [memory,memory-fs,base-fs,nio-fs]");
        }
        IndexManager.closeOnExit(directory);
        return directory;
    }

    public String checkDir() {
        File file;
        String indexDir = this.searchConfig.getDir();
        if (indexDir == null || indexDir.length() == 0) {
            indexDir = System.getProperty("user.dir") + File.separator + defaultIndexDirName;
        }
        if (!(file = new File(this.searchConfig.getDir())).exists()) {
            log.info("indexPath is null,it will be created automatically :" + this.searchConfig.getDir());
            file.mkdirs();
        }
        return indexDir;
    }

    @Bean(value={"indexWriter"})
    public IndexWriter indexWriter(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(new StandardAnalyzer());
        IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);
        if (this.searchConfig.getIndexInit().booleanValue()) {
            indexWriter.deleteAll();
            indexWriter.commit();
        }
        IndexManager.closeOnExit(indexWriter);
        return indexWriter;
    }

    @Bean(value={"searcherManager"})
    public SearcherManager searcherManager(IndexWriter indexWriter) throws IOException {
        SearcherManager searcherManager = new SearcherManager(indexWriter, new SearcherFactory());
        ControlledRealTimeReopenThread<IndexSearcher> cRTReopenThead = new ControlledRealTimeReopenThread<IndexSearcher>(indexWriter, searcherManager, 5.0, 0.025);
        cRTReopenThead.setDaemon(true);
        cRTReopenThead.setName("Thread-update IndexReader");
        cRTReopenThead.start();
        IndexManager.closeOnExit(searcherManager);
        IndexManager.closeOnExit(cRTReopenThead);
        return searcherManager;
    }

    @Bean(value={"indexExecutor"})
    public ThreadPoolTaskExecutor taskExecutro() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.searchConfig.getThreadCoreSize().intValue());
        taskExecutor.setMaxPoolSize(this.searchConfig.getThreadMaxSize().intValue());
        taskExecutor.setQueueCapacity(this.searchConfig.getThreadQueueSize().intValue());
        taskExecutor.setKeepAliveSeconds(60);
        taskExecutor.setThreadNamePrefix("indexExecutor--");
        taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        taskExecutor.setAwaitTerminationSeconds(60);
        return taskExecutor;
    }
}

