/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.service.impl;

import cn.langpy.simsearch.config.SimSearchConfig;
import cn.langpy.simsearch.model.IndexContent;
import cn.langpy.simsearch.model.IndexItem;
import cn.langpy.simsearch.service.IndexService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultIndexService
implements IndexService {
    private static String entityField = "entitySourceName";
    @Autowired
    IndexWriter indexWriter;
    @Autowired
    SearcherManager searcherManager;
    @Autowired
    SimSearchConfig searchConfig;

    @Override
    public synchronized void createIndex(IndexContent indexContent) {
        try {
            Document doc = new Document();
            doc.add(new StringField(indexContent.getIdName(), indexContent.getIdValue(), Field.Store.YES));
            doc.add(new StringField(entityField, indexContent.getEntitySource().getSimpleName(), Field.Store.YES));
            for (IndexItem item : indexContent.getItems()) {
                doc.add(new TextField(item.getName(), item.getValue(), Field.Store.YES));
            }
            this.deleteIndex(indexContent.getEntitySource().getSimpleName(), indexContent.getIdName(), indexContent.getIdValue());
            this.indexWriter.addDocument(doc);
            this.indexWriter.flush();
            this.indexWriter.commit();
        }
        catch (IOException e) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    @Override
    public void deleteIndex(String entityName, String idName, String idValue) {
        try {
            this.indexWriter.deleteDocuments(this.buildStrictQuery(entityName, idName, idValue));
            this.indexWriter.commit();
        }
        catch (IOException e) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    @Override
    public void deleteAll() {
        try {
            this.indexWriter.deleteAll();
            this.indexWriter.commit();
        }
        catch (IOException e) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    @Override
    public List<Document> searchIndexs(String entityName, String name, String value) {
        return this.searchIndexs(entityName, name, value, this.searchConfig.getResultSize());
    }

    public BooleanQuery buildStrictQuery(String entityName, String name, String value) {
        TermQuery query1 = new TermQuery(new Term(name, value));
        TermQuery query2 = new TermQuery(new Term(entityField, entityName));
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(query1, BooleanClause.Occur.MUST);
        boolQuery.add(query2, BooleanClause.Occur.MUST);
        return boolQuery.build();
    }

    public Query buildFuzzyQuery(String entityName, String name, String value) {
        Query query1 = null;
        if (value.matches("^[a-zA-Z0-9]+$")) {
            int maxEdit = 2;
            if (value.length() < 3) {
                maxEdit = 0;
            }
            query1 = new FuzzyQuery(new Term(name, value), maxEdit);
        } else {
            QueryParser queryParser = new QueryParser(name, new StandardAnalyzer());
            try {
                query1 = queryParser.parse(value);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        TermQuery query2 = new TermQuery(new Term(entityField, entityName));
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(query1, BooleanClause.Occur.MUST);
        boolQuery.add(query2, BooleanClause.Occur.MUST);
        return boolQuery.build();
    }

    @Override
    public List<Document> searchIndexs(String name, String value) {
        ScoreDoc[] scoreDocs;
        if (value == null || value.length() == 0 || name == null) {
            return Collections.emptyList();
        }
        value = value.trim();
        ArrayList<Document> documents = new ArrayList<Document>();
        IndexSearcher indexSearcher = null;
        try {
            this.searcherManager.maybeRefresh();
            indexSearcher = (IndexSearcher)this.searcherManager.acquire();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TopDocs topDocs = null;
        QueryParser qp = new QueryParser(name, new StandardAnalyzer());
        try {
            Query q = qp.parse(value);
            topDocs = indexSearcher.search(q, this.searchConfig.getResultSize());
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            int docID = scoreDoc.doc;
            try {
                Document doc = indexSearcher.doc(docID);
                documents.add(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return documents;
    }

    @Override
    public List<Document> searchIndexs(String entityName, String name, String value, int topn) {
        ScoreDoc[] scoreDocs;
        if (value == null || value.length() == 0 || name == null) {
            return Collections.emptyList();
        }
        value = value.trim();
        ArrayList<Document> documents = new ArrayList<Document>();
        IndexSearcher indexSearcher = null;
        try {
            this.searcherManager.maybeRefresh();
            indexSearcher = (IndexSearcher)this.searcherManager.acquire();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TopDocs topDocs = null;
        try {
            topDocs = indexSearcher.search(this.buildFuzzyQuery(entityName, name, value), topn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            int docID = scoreDoc.doc;
            try {
                Document doc = indexSearcher.doc(docID);
                documents.add(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return documents;
    }
}

