/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.service.impl;

import cn.langpy.simsearch.annotation.CreateIndex;
import cn.langpy.simsearch.annotation.DeleteIndex;
import cn.langpy.simsearch.annotation.IndexColumn;
import cn.langpy.simsearch.annotation.IndexId;
import cn.langpy.simsearch.annotation.SearchIndex;
import cn.langpy.simsearch.model.IndexContent;
import cn.langpy.simsearch.model.IndexItem;
import cn.langpy.simsearch.service.AopService;
import cn.langpy.simsearch.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DefaultAopService
implements AopService {
    private static final List<Class<?>> baseTypes = Arrays.asList(Integer.class, Double.class, Float.class, String.class, Boolean.class, List.class, Math.class);

    public String getIndexParam(String indexParam, String[] paramNames, Method method) {
        if (StringUtils.isEmpty((Object)indexParam)) {
            if (paramNames.length == 0) {
                throw new RuntimeException("can not create index for method " + method.getName() + ",cause it has not any parameter");
            }
            indexParam = paramNames[0];
        }
        return indexParam;
    }

    public Object getIndexParamValue(String[] paramNames, Object[] paramValues, String indexParamName, Method method) {
        int indexParamIndex = -1;
        for (int i = 0; i < paramNames.length; ++i) {
            if (!indexParamName.equals(paramNames[i])) continue;
            indexParamIndex = i;
            break;
        }
        if (indexParamIndex == -1) {
            throw new RuntimeException("error indexParam in @CreateIndex on method " + method.getName());
        }
        Object indexParamValue = paramValues[indexParamIndex];
        return indexParamValue;
    }

    public void checkParamValue(Object indexParamValue) {
        Class<?> aClass = indexParamValue.getClass();
        if (baseTypes.contains(aClass)) {
            throw new RuntimeException("can not create index for base types:" + baseTypes);
        }
    }

    @Override
    public IndexContent getIndexContent(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        CreateIndex createIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(CreateIndex.class);
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String indexParamName = this.getIndexParam(createIndex.indexParam(), paramNames, method);
        Object[] paramValues = joinPoint.getArgs();
        Object indexParamValue = this.getIndexParamValue(paramNames, paramValues, indexParamName, method);
        this.checkParamValue(indexParamValue);
        Field[] fields = indexParamValue.getClass().getDeclaredFields();
        IndexContent indexContent = new IndexContent();
        ArrayList<IndexItem> indexItems = new ArrayList<IndexItem>();
        for (int j = 0; j < fields.length; ++j) {
            Field field = fields[j];
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            IndexId indexId = field.getAnnotation(IndexId.class);
            if (indexId != null) {
                Object indexIdColumnValue = ReflectUtil.getFieldValue(field, indexParamValue);
                indexContent.setIdName(field.getName());
                indexContent.setIdValue(indexIdColumnValue + "");
                continue;
            }
            IndexColumn indexColumn = field.getAnnotation(IndexColumn.class);
            if (indexColumn == null) continue;
            Object indexColumnValue = ReflectUtil.getFieldValue(field, indexParamValue);
            IndexItem indexItem = new IndexItem();
            indexItem.setName(field.getName());
            indexItem.setValue(indexColumnValue + "");
            indexItems.add(indexItem);
        }
        indexContent.setEntitySource(indexParamValue.getClass());
        indexContent.setItems(indexItems);
        return indexContent;
    }

    @Override
    public IndexItem getDeleteItem(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        DeleteIndex createIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(DeleteIndex.class);
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String indexParamName = this.getIndexParam(createIndex.indexParam(), paramNames, method);
        Object[] paramValues = joinPoint.getArgs();
        Object indexParamValue = this.getIndexParamValue(paramNames, paramValues, indexParamName, method);
        this.checkParamValue(indexParamValue);
        Field[] fields = indexParamValue.getClass().getDeclaredFields();
        IndexItem indexContent = new IndexItem();
        for (int j = 0; j < fields.length; ++j) {
            IndexId indexId;
            Field field = fields[j];
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || (indexId = field.getAnnotation(IndexId.class)) == null) continue;
            Object indexIdColumnValue = ReflectUtil.getFieldValue(field, indexParamValue);
            indexContent.setName(field.getName());
            indexContent.setValue(indexIdColumnValue + "");
            break;
        }
        indexContent.setEntitySource(indexParamValue.getClass());
        return indexContent;
    }

    @Override
    public IndexItem getSearchItem(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        SearchIndex createIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(SearchIndex.class);
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String indexParamName = this.getIndexParam(createIndex.indexParam(), paramNames, method);
        Object[] paramValues = joinPoint.getArgs();
        Object indexParamValue = this.getIndexParamValue(paramNames, paramValues, indexParamName, method);
        this.checkParamValue(indexParamValue);
        String searchColumnName = createIndex.by();
        if (StringUtils.isEmpty((Object)searchColumnName)) {
            throw new RuntimeException("error by in @SearchIndex on method " + method.getName());
        }
        Field[] fields = indexParamValue.getClass().getDeclaredFields();
        IndexItem indexContent = new IndexItem();
        for (int j = 0; j < fields.length; ++j) {
            Field field = fields[j];
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || !searchColumnName.equals(field.getName())) continue;
            Object indexIdColumnValue = ReflectUtil.getFieldValue(field, indexParamValue);
            indexContent.setName(field.getName());
            indexContent.setValue(indexIdColumnValue + "");
        }
        indexContent.setEntitySource(indexParamValue.getClass());
        return indexContent;
    }

    @Override
    public Class<?> getReturnClass(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        return method.getReturnType();
    }
}

