/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.intercepter;

import cn.langpy.simsearch.model.IndexContent;
import cn.langpy.simsearch.service.AopService;
import cn.langpy.simsearch.service.IndexService;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CreateIndexAspect {
    @Resource(name="indexExecutor")
    ThreadPoolTaskExecutor executor;
    @Autowired
    AopService aopService;
    @Autowired
    IndexService indexService;

    @Pointcut(value="@annotation(cn.langpy.simsearch.annotation.CreateIndex)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object re = joinPoint.proceed();
        this.executor.submit(() -> {
            IndexContent indexContent = this.aopService.getIndexContent(joinPoint);
            this.indexService.createIndex(indexContent);
        });
        return re;
    }
}

