/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.idversion;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.idversion.IDVersionPostingsReader;
import org.apache.lucene.codecs.idversion.IDVersionPostingsWriter;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsReader;
import org.apache.lucene.codecs.idversion.VersionBlockTreeTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class IDVersionPostingsFormat
extends PostingsFormat {
    public static final long MIN_VERSION = 0L;
    public static final long MAX_VERSION = 0x3FFFFFFFFFFFFFFFL;
    private final int minTermsInBlock;
    private final int maxTermsInBlock;

    public IDVersionPostingsFormat() {
        this(25, 48);
    }

    public IDVersionPostingsFormat(int minTermsInBlock, int maxTermsInBlock) {
        super("IDVersion");
        this.minTermsInBlock = minTermsInBlock;
        this.maxTermsInBlock = maxTermsInBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        VersionBlockTreeTermsWriter versionBlockTreeTermsWriter;
        block3: {
            IDVersionPostingsWriter postingsWriter = new IDVersionPostingsWriter(state);
            boolean success = false;
            try {
                VersionBlockTreeTermsWriter ret = new VersionBlockTreeTermsWriter(state, postingsWriter, this.minTermsInBlock, this.maxTermsInBlock);
                success = true;
                versionBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return versionBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        VersionBlockTreeTermsReader versionBlockTreeTermsReader;
        block3: {
            IDVersionPostingsReader postingsReader = new IDVersionPostingsReader();
            boolean success = false;
            try {
                VersionBlockTreeTermsReader ret = new VersionBlockTreeTermsReader(state.directory, state.fieldInfos, state.segmentInfo, postingsReader, state.context, state.segmentSuffix);
                success = true;
                versionBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return versionBlockTreeTermsReader;
    }

    public static long bytesToLong(BytesRef bytes) {
        return ((long)bytes.bytes[bytes.offset] & 0xFFL) << 56 | ((long)bytes.bytes[bytes.offset + 1] & 0xFFL) << 48 | ((long)bytes.bytes[bytes.offset + 2] & 0xFFL) << 40 | ((long)bytes.bytes[bytes.offset + 3] & 0xFFL) << 32 | ((long)bytes.bytes[bytes.offset + 4] & 0xFFL) << 24 | ((long)bytes.bytes[bytes.offset + 5] & 0xFFL) << 16 | ((long)bytes.bytes[bytes.offset + 6] & 0xFFL) << 8 | (long)bytes.bytes[bytes.offset + 7] & 0xFFL;
    }

    public static void longToBytes(long v, BytesRef bytes) {
        if (v > 0x3FFFFFFFFFFFFFFFL || v < 0L) {
            throw new IllegalArgumentException("version must be >= MIN_VERSION=0 and <= MAX_VERSION=4611686018427387903 (got: " + v + ")");
        }
        bytes.offset = 0;
        bytes.length = 8;
        bytes.bytes[0] = (byte)(v >> 56);
        bytes.bytes[1] = (byte)(v >> 48);
        bytes.bytes[2] = (byte)(v >> 40);
        bytes.bytes[3] = (byte)(v >> 32);
        bytes.bytes[4] = (byte)(v >> 24);
        bytes.bytes[5] = (byte)(v >> 16);
        bytes.bytes[6] = (byte)(v >> 8);
        bytes.bytes[7] = (byte)v;
        assert (IDVersionPostingsFormat.bytesToLong(bytes) == v) : IDVersionPostingsFormat.bytesToLong(bytes) + " vs " + v + " bytes=" + bytes;
    }
}

