/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.config;

import java.io.File;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class IndexContextInit
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public static Logger log = Logger.getLogger(IndexContextInit.class.toString());

    public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
        File file;
        String indexPath = configurableApplicationContext.getEnvironment().getProperty("sim-search.dir");
        if (indexPath == null || indexPath.length() == 0) {
            indexPath = System.getProperty("user.dir") + File.separator + "indexs";
        }
        if (!(file = new File(indexPath)).exists()) {
            log.info("indexPath is null,it will be created automatically :" + indexPath);
            file.mkdirs();
        }
    }
}

