/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.aop;

import cn.langpy.simsearch.task.IndexTask;
import java.util.List;
import org.apache.lucene.search.SearcherManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SearchAspect {
    @Autowired
    SearcherManager searcherManager;
    @Autowired
    IndexTask indexTask;

    @Pointcut(value="@annotation(cn.langpy.simsearch.annotation.SearchIndex)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object before(ProceedingJoinPoint joinPoint) throws Throwable {
        List searchResult = (List)this.indexTask.searchIndex(joinPoint);
        if (searchResult == null || searchResult.size() == 0) {
            return joinPoint.proceed();
        }
        return this.indexTask.searchIndex(joinPoint);
    }
}

