/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.task;

import cn.langpy.simsearch.annotation.CreateIndex;
import cn.langpy.simsearch.annotation.DeleteIndex;
import cn.langpy.simsearch.annotation.IndexColumn;
import cn.langpy.simsearch.annotation.IndexId;
import cn.langpy.simsearch.annotation.SearchIndex;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TopDocs;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class IndexTask {
    @Autowired
    IndexWriter indexWriter;
    @Autowired
    SearcherManager searcherManager;

    @Async(value="indexExecutor")
    public void createIndex(ProceedingJoinPoint joinPoint) {
        CreateIndex createIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(CreateIndex.class);
        Object[] params = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String index = StringUtils.isEmpty((Object)createIndex.indexParam()) ? paramNames[0] : createIndex.indexParam();
        for (int i = 0; i < paramNames.length; ++i) {
            if (!index.equals(paramNames[i])) continue;
            Object arg = params[i];
            String indexIdColumn = "";
            Object indexIdValue = "";
            Field[] fields = arg.getClass().getDeclaredFields();
            Document doc = new Document();
            for (int j = 0; j < fields.length; ++j) {
                IndexColumn indexColumn;
                IndexId indexId = fields[j].getAnnotation(IndexId.class);
                if (indexId != null && StringUtils.isEmpty((Object)indexIdValue)) {
                    indexIdColumn = fields[j].getName();
                    PropertyDescriptor columnIdPd = null;
                    try {
                        columnIdPd = new PropertyDescriptor(indexIdColumn, arg.getClass());
                        Method idMethod = columnIdPd.getReadMethod();
                        indexIdValue = idMethod.invoke(arg, new Object[0]);
                        doc.add(new StringField(indexIdColumn, indexIdValue + "", Field.Store.YES));
                        continue;
                    }
                    catch (IntrospectionException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if ((indexColumn = (IndexColumn)AnnotationUtils.findAnnotation((AnnotatedElement)fields[j], IndexColumn.class)) == null) continue;
                String indexNameColumn = fields[j].getName();
                PropertyDescriptor columnPd = null;
                try {
                    columnPd = new PropertyDescriptor(indexNameColumn, arg.getClass());
                    Method columnMethod = columnPd.getReadMethod();
                    Object indexNameValue = columnMethod.invoke(arg, new Object[0]);
                    doc.add(new TextField(indexNameColumn, indexNameValue + "", Field.Store.YES));
                    continue;
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.indexWriter.deleteDocuments(new Term(indexIdColumn, indexIdValue + ""));
                this.indexWriter.addDocument(doc);
                this.indexWriter.commit();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Async(value="indexExecutor")
    public void deleteIndex(ProceedingJoinPoint joinPoint) {
        DeleteIndex createIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(DeleteIndex.class);
        Object[] params = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String index = StringUtils.isEmpty((Object)createIndex.indexParam()) ? paramNames[0] : createIndex.indexParam();
        block5: for (int i = 0; i < paramNames.length; ++i) {
            if (!index.equals(paramNames[i])) continue;
            Object arg = params[i];
            String indexIdColumn = "";
            Object indexIdValue = "";
            Field[] fields = arg.getClass().getDeclaredFields();
            Document doc = new Document();
            for (int j = 0; j < fields.length; ++j) {
                IndexId indexId = fields[j].getAnnotation(IndexId.class);
                if (indexId == null || !StringUtils.isEmpty((Object)indexIdValue)) continue;
                indexIdColumn = fields[j].getName();
                PropertyDescriptor columnIdPd = null;
                try {
                    columnIdPd = new PropertyDescriptor(indexIdColumn, arg.getClass());
                    Method idMethod = columnIdPd.getReadMethod();
                    indexIdValue = idMethod.invoke(arg, new Object[0]);
                    this.indexWriter.deleteDocuments(new Term(indexIdColumn, indexIdValue + ""));
                    this.indexWriter.addDocument(doc);
                    this.indexWriter.commit();
                    continue block5;
                }
                catch (IntrospectionException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Object searchIndex(ProceedingJoinPoint joinPoint) {
        ScoreDoc[] scoreDocs;
        SearchIndex searchIndex = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(SearchIndex.class);
        Object[] params = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        String indexName = StringUtils.isEmpty((Object)searchIndex.by()) ? paramNames[0] : searchIndex.by();
        Class returnType = searchIndex.searchEntity();
        ArrayList documents = new ArrayList();
        Object arg = params[0];
        IndexSearcher indexSearcher = null;
        try {
            this.searcherManager.maybeRefresh();
            indexSearcher = (IndexSearcher)this.searcherManager.acquire();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        QueryParser parser = new QueryParser(indexName, new StandardAnalyzer());
        Query query = null;
        TopDocs topDocs = null;
        try {
            query = parser.parse(arg + "");
            topDocs = indexSearcher.search(query, 10);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ScoreDoc scoreDoc : scoreDocs = topDocs.scoreDocs) {
            int docID = scoreDoc.doc;
            Document doc = null;
            try {
                doc = indexSearcher.doc(docID);
                Object re = returnType.newInstance();
                for (Field field : returnType.getDeclaredFields()) {
                    String fieldName = field.getName();
                    PropertyDescriptor columnPd = new PropertyDescriptor(fieldName, returnType);
                    Method columnMethod = columnPd.getWriteMethod();
                    columnMethod.invoke(re, doc.get(fieldName));
                }
                documents.add(re);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return documents;
    }
}

