/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simsearch.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

@Configuration
@EnableAsync
public class IndexConfig {
    String indexLocalDir = System.getProperty("user.dir") + "/indexs";
    @Value(value="${sim-search.dir:}")
    String indexDir;
    @Value(value="${sim-search.size.core:10}")
    Integer coreSize;
    @Value(value="${sim-search.size.max:200}")
    Integer maxSize;
    @Value(value="${sim-search.size.queue:20000}")
    Integer queueSize;
    @Value(value="${sim-search.index.init:false}")
    boolean indexInit;

    @Bean
    public Directory directory() throws IOException {
        Path path;
        File file;
        if (StringUtils.isEmpty((Object)this.indexDir)) {
            this.indexDir = this.indexLocalDir;
        }
        if (!(file = (path = Paths.get(this.indexDir, new String[0])).toFile()).exists()) {
            file.mkdirs();
        }
        return FSDirectory.open(file);
    }

    @Bean
    public IndexReader reader(Directory directory) {
        DirectoryReader reader = null;
        try {
            reader = DirectoryReader.open(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return reader;
    }

    @Bean
    public IndexSearcher searcher(IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        return searcher;
    }

    @Bean
    public IndexWriter indexWriter(Directory directory) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LATEST, new StandardAnalyzer());
        IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);
        if (this.indexInit) {
            indexWriter.deleteAll();
            indexWriter.commit();
        }
        return indexWriter;
    }

    @Bean
    public SearcherManager searcherManager(IndexWriter indexWriter) throws IOException {
        SearcherManager searcherManager = new SearcherManager(indexWriter, false, new SearcherFactory());
        ControlledRealTimeReopenThread<IndexSearcher> cRTReopenThead = new ControlledRealTimeReopenThread<IndexSearcher>(new TrackingIndexWriter(indexWriter), searcherManager, 5.0, 0.025);
        cRTReopenThead.setDaemon(true);
        cRTReopenThead.setName("\u66f4\u65b0IndexReader\u7ebf\u7a0b");
        cRTReopenThead.start();
        return searcherManager;
    }

    @Bean(value={"indexExecutor"})
    public Executor taskExecutro() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.coreSize.intValue());
        taskExecutor.setMaxPoolSize(this.maxSize.intValue());
        taskExecutor.setQueueCapacity(this.queueSize.intValue());
        taskExecutor.setKeepAliveSeconds(60);
        taskExecutor.setThreadNamePrefix("indexExecutor--");
        taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        taskExecutor.setAwaitTerminationSeconds(60);
        return taskExecutor;
    }
}

