/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.simforkjoin.core;

import cn.langpy.simforkjoin.annotation.ForkJoin;
import cn.langpy.simforkjoin.core.ContextTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.logging.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ForkJoinHandler {
    public static Logger log = Logger.getLogger(ForkJoinHandler.class.toString());
    @Autowired
    ContextTask contextTask;

    @Pointcut(value="@annotation(cn.langpy.simforkjoin.annotation.ForkJoin)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object before(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] args = joinPoint.getArgs();
        ForkJoin forkJoin = ((MethodSignature)joinPoint.getSignature()).getMethod().getAnnotation(ForkJoin.class);
        this.contextTask.validate(forkJoin, args);
        int threshold = forkJoin.threshold();
        List arg = (List)args[0];
        int len = arg.size();
        if (len < threshold) {
            return joinPoint.proceed(args);
        }
        Executor threadExecutor = this.contextTask.getExecutor(forkJoin);
        ExecutorCompletionService completionService = new ExecutorCompletionService(threadExecutor);
        int n = this.contextTask.execute(completionService, joinPoint, args, threshold);
        ArrayList results = new ArrayList();
        for (int i = 0; i < n; ++i) {
            List result = (List)completionService.take().get();
            if (result == null) continue;
            results.addAll(result);
        }
        if (forkJoin.isReturn()) {
            return results;
        }
        return null;
    }
}

