/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.nlp2cron.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class CrondConfig {
    public String modelPath = "src\\main\\resources\\model";
    public JSONObject inputId2Word = null;
    public JSONObject inputWord2Id = null;
    public JSONObject outputId2Word = null;

    public CrondConfig() {
        try (InputStream inputWordsStream = CrondConfig.class.getResourceAsStream("/input.json");
             InputStream outputWordsStream = CrondConfig.class.getResourceAsStream("/output.json");){
            String inMapping = IOUtils.toString((InputStream)inputWordsStream, (String)"utf-8");
            this.inputId2Word = JSON.parseObject((String)inMapping);
            this.inputWord2Id = new JSONObject();
            for (String id : this.inputId2Word.keySet()) {
                String word = this.inputId2Word.getString(id);
                this.inputWord2Id.put(word, (Object)Integer.valueOf(id));
            }
            String outMapping = IOUtils.toString((InputStream)outputWordsStream, (String)"utf-8");
            this.outputId2Word = JSON.parseObject((String)outMapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public JSONObject getInputId2Word() {
        return this.inputId2Word;
    }

    public void setInputId2Word(JSONObject inputId2Word) {
        this.inputId2Word = inputId2Word;
    }

    public JSONObject getInputWord2Id() {
        return this.inputWord2Id;
    }

    public void setInputWord2Id(JSONObject inputWord2Id) {
        this.inputWord2Id = inputWord2Id;
    }

    public JSONObject getOutputId2Word() {
        return this.outputId2Word;
    }

    public void setOutputId2Word(JSONObject outputId2Word) {
        this.outputId2Word = outputId2Word;
    }
}

