/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MaxPoolGradWithArgmax<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number, U extends Number> MaxPoolGradWithArgmax<T> create(Scope scope, Operand<T> input, Operand<T> grad, Operand<U> argmax, List<Long> ksize, List<Long> strides, String padding, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("MaxPoolGradWithArgmax", scope.makeOpName("MaxPoolGradWithArgmax"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(argmax.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        long[] ksizeArray = new long[ksize.size()];
        for (int i = 0; i < ksizeArray.length; ++i) {
            ksizeArray[i] = ksize.get(i);
        }
        opBuilder.setAttr("ksize", ksizeArray);
        long[] stridesArray = new long[strides.size()];
        for (int i = 0; i < stridesArray.length; ++i) {
            stridesArray[i] = strides.get(i);
        }
        opBuilder.setAttr("strides", stridesArray);
        opBuilder.setAttr("padding", padding);
        if (options != null) {
            for (Options opts : options) {
                if (opts.includeBatchInIndex == null) continue;
                opBuilder.setAttr("include_batch_in_index", opts.includeBatchInIndex);
            }
        }
        return new MaxPoolGradWithArgmax<T>(opBuilder.build());
    }

    public static Options includeBatchInIndex(Boolean includeBatchInIndex) {
        return new Options().includeBatchInIndex(includeBatchInIndex);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private MaxPoolGradWithArgmax(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean includeBatchInIndex;

        public Options includeBatchInIndex(Boolean includeBatchInIndex) {
            this.includeBatchInIndex = includeBatchInIndex;
            return this;
        }

        private Options() {
        }
    }
}

