/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SnapshotDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static SnapshotDataset create(Scope scope, Operand<?> inputDataset, Operand<String> path, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("SnapshotDataset", scope.makeOpName("SnapshotDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(path.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression != null) {
                    opBuilder.setAttr("compression", opts.compression);
                }
                if (opts.readerPathPrefix != null) {
                    opBuilder.setAttr("reader_path_prefix", opts.readerPathPrefix);
                }
                if (opts.writerPathPrefix != null) {
                    opBuilder.setAttr("writer_path_prefix", opts.writerPathPrefix);
                }
                if (opts.shardSizeBytes != null) {
                    opBuilder.setAttr("shard_size_bytes", opts.shardSizeBytes);
                }
                if (opts.pendingSnapshotExpirySeconds != null) {
                    opBuilder.setAttr("pending_snapshot_expiry_seconds", opts.pendingSnapshotExpirySeconds);
                }
                if (opts.numReaderThreads != null) {
                    opBuilder.setAttr("num_reader_threads", opts.numReaderThreads);
                }
                if (opts.readerBufferSize != null) {
                    opBuilder.setAttr("reader_buffer_size", opts.readerBufferSize);
                }
                if (opts.numWriterThreads != null) {
                    opBuilder.setAttr("num_writer_threads", opts.numWriterThreads);
                }
                if (opts.writerBufferSize == null) continue;
                opBuilder.setAttr("writer_buffer_size", opts.writerBufferSize);
            }
        }
        return new SnapshotDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public static Options readerPathPrefix(String readerPathPrefix) {
        return new Options().readerPathPrefix(readerPathPrefix);
    }

    public static Options writerPathPrefix(String writerPathPrefix) {
        return new Options().writerPathPrefix(writerPathPrefix);
    }

    public static Options shardSizeBytes(Long shardSizeBytes) {
        return new Options().shardSizeBytes(shardSizeBytes);
    }

    public static Options pendingSnapshotExpirySeconds(Long pendingSnapshotExpirySeconds) {
        return new Options().pendingSnapshotExpirySeconds(pendingSnapshotExpirySeconds);
    }

    public static Options numReaderThreads(Long numReaderThreads) {
        return new Options().numReaderThreads(numReaderThreads);
    }

    public static Options readerBufferSize(Long readerBufferSize) {
        return new Options().readerBufferSize(readerBufferSize);
    }

    public static Options numWriterThreads(Long numWriterThreads) {
        return new Options().numWriterThreads(numWriterThreads);
    }

    public static Options writerBufferSize(Long writerBufferSize) {
        return new Options().writerBufferSize(writerBufferSize);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private SnapshotDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private String compression;
        private String readerPathPrefix;
        private String writerPathPrefix;
        private Long shardSizeBytes;
        private Long pendingSnapshotExpirySeconds;
        private Long numReaderThreads;
        private Long readerBufferSize;
        private Long numWriterThreads;
        private Long writerBufferSize;

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }

        public Options readerPathPrefix(String readerPathPrefix) {
            this.readerPathPrefix = readerPathPrefix;
            return this;
        }

        public Options writerPathPrefix(String writerPathPrefix) {
            this.writerPathPrefix = writerPathPrefix;
            return this;
        }

        public Options shardSizeBytes(Long shardSizeBytes) {
            this.shardSizeBytes = shardSizeBytes;
            return this;
        }

        public Options pendingSnapshotExpirySeconds(Long pendingSnapshotExpirySeconds) {
            this.pendingSnapshotExpirySeconds = pendingSnapshotExpirySeconds;
            return this;
        }

        public Options numReaderThreads(Long numReaderThreads) {
            this.numReaderThreads = numReaderThreads;
            return this;
        }

        public Options readerBufferSize(Long readerBufferSize) {
            this.readerBufferSize = readerBufferSize;
            return this;
        }

        public Options numWriterThreads(Long numWriterThreads) {
            this.numWriterThreads = numWriterThreads;
            return this;
        }

        public Options writerBufferSize(Long writerBufferSize) {
            this.writerBufferSize = writerBufferSize;
            return this;
        }

        private Options() {
        }
    }
}

