/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedMatMulWithBiasAndReluAndRequantize<W>
extends PrimitiveOp {
    private Output<W> out;
    private Output<Float> minOut;
    private Output<Float> maxOut;

    public static <W, T, U, V> QuantizedMatMulWithBiasAndReluAndRequantize<W> create(Scope scope, Operand<T> a, Operand<U> b, Operand<V> bias, Operand<Float> minA, Operand<Float> maxA, Operand<Float> minB, Operand<Float> maxB, Operand<Float> minFreezedOutput, Operand<Float> maxFreezedOutput, Class<W> Toutput, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedMatMulWithBiasAndReluAndRequantize", scope.makeOpName("QuantizedMatMulWithBiasAndReluAndRequantize"));
        opBuilder.addInput(a.asOutput());
        opBuilder.addInput(b.asOutput());
        opBuilder.addInput(bias.asOutput());
        opBuilder.addInput(minA.asOutput());
        opBuilder.addInput(maxA.asOutput());
        opBuilder.addInput(minB.asOutput());
        opBuilder.addInput(maxB.asOutput());
        opBuilder.addInput(minFreezedOutput.asOutput());
        opBuilder.addInput(maxFreezedOutput.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("Toutput", DataType.fromClass(Toutput));
        if (options != null) {
            for (Options opts : options) {
                if (opts.transposeA != null) {
                    opBuilder.setAttr("transpose_a", opts.transposeA);
                }
                if (opts.transposeB != null) {
                    opBuilder.setAttr("transpose_b", opts.transposeB);
                }
                if (opts.inputQuantMode == null) continue;
                opBuilder.setAttr("input_quant_mode", opts.inputQuantMode);
            }
        }
        return new QuantizedMatMulWithBiasAndReluAndRequantize<W>(opBuilder.build());
    }

    public static Options transposeA(Boolean transposeA) {
        return new Options().transposeA(transposeA);
    }

    public static Options transposeB(Boolean transposeB) {
        return new Options().transposeB(transposeB);
    }

    public static Options inputQuantMode(String inputQuantMode) {
        return new Options().inputQuantMode(inputQuantMode);
    }

    public Output<W> out() {
        return this.out;
    }

    public Output<Float> minOut() {
        return this.minOut;
    }

    public Output<Float> maxOut() {
        return this.maxOut;
    }

    private QuantizedMatMulWithBiasAndReluAndRequantize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
        this.minOut = operation.output(outputIdx++);
        this.maxOut = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean transposeA;
        private Boolean transposeB;
        private String inputQuantMode;

        public Options transposeA(Boolean transposeA) {
            this.transposeA = transposeA;
            return this;
        }

        public Options transposeB(Boolean transposeB) {
            this.transposeB = transposeB;
            return this;
        }

        public Options inputQuantMode(String inputQuantMode) {
            this.inputQuantMode = inputQuantMode;
            return this;
        }

        private Options() {
        }
    }
}

