/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ExperimentalRebatchDataset
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> handle;

    public static ExperimentalRebatchDataset create(Scope scope, Operand<?> inputDataset, Operand<Long> numReplicas, List<Class<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("ExperimentalRebatchDataset", scope.makeOpName("ExperimentalRebatchDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numReplicas.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = DataType.fromClass(outputTypes.get(i));
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.useFallback == null) continue;
                opBuilder.setAttr("use_fallback", opts.useFallback);
            }
        }
        return new ExperimentalRebatchDataset(opBuilder.build());
    }

    public static Options useFallback(Boolean useFallback) {
        return new Options().useFallback(useFallback);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<Object> asOutput() {
        return this.handle;
    }

    private ExperimentalRebatchDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean useFallback;

        public Options useFallback(Boolean useFallback) {
            this.useFallback = useFallback;
            return this;
        }

        private Options() {
        }
    }
}

