/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CudnnRNNCanonicalToParamsV2<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> params;

    public static <T extends Number> CudnnRNNCanonicalToParamsV2<T> create(Scope scope, Operand<Integer> numLayers, Operand<Integer> numUnits, Operand<Integer> inputSize, Iterable<Operand<T>> weights, Iterable<Operand<T>> biases, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CudnnRNNCanonicalToParamsV2", scope.makeOpName("CudnnRNNCanonicalToParamsV2"));
        opBuilder.addInput(numLayers.asOutput());
        opBuilder.addInput(numUnits.asOutput());
        opBuilder.addInput(inputSize.asOutput());
        opBuilder.addInputList(Operands.asOutputs(weights));
        opBuilder.addInputList(Operands.asOutputs(biases));
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj == null) continue;
                opBuilder.setAttr("num_proj", opts.numProj);
            }
        }
        return new CudnnRNNCanonicalToParamsV2<T>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public Output<T> params() {
        return this.params;
    }

    @Override
    public Output<T> asOutput() {
        return this.params;
    }

    private CudnnRNNCanonicalToParamsV2(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.params = operation.output(outputIdx++);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }

        private Options() {
        }
    }
}

