/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.tensorflow.EagerOperationBuilder;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.OperationBuilder;
import org.tensorflow.TensorFlow;

public final class EagerSession
implements ExecutionEnvironment,
AutoCloseable {
    private static volatile EagerSession defaultSession = null;
    private final NativeResourceCollector nativeResources;
    private final ResourceCleanupStrategy resourceCleanupStrategy;
    private long nativeHandle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EagerSession initDefault(Options options) {
        Class<EagerSession> clazz = EagerSession.class;
        synchronized (EagerSession.class) {
            if (defaultSession != null) {
                throw new IllegalStateException("Default eager session is already initialized");
            }
            defaultSession = options.build();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EagerSession getDefault() {
        if (defaultSession != null) return defaultSession;
        Class<EagerSession> clazz = EagerSession.class;
        synchronized (EagerSession.class) {
            if (defaultSession != null) return defaultSession;
            defaultSession = EagerSession.options().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultSession;
        }
    }

    public static EagerSession create() {
        return EagerSession.options().build();
    }

    public static Options options() {
        return new Options();
    }

    @Override
    public synchronized void close() {
        if (this == defaultSession) {
            throw new IllegalStateException("Default eager session cannot be closed");
        }
        if (this.nativeHandle != 0L) {
            if (this.resourceCleanupStrategy == ResourceCleanupStrategy.IN_BACKGROUND) {
                this.nativeResources.stopCleanupThread();
            }
            this.nativeResources.deleteAll();
            EagerSession.delete(this.nativeHandle);
            this.nativeHandle = 0L;
        }
    }

    @Override
    public OperationBuilder opBuilder(String type, String name) {
        if (this.resourceCleanupStrategy == ResourceCleanupStrategy.ON_SAFE_POINTS) {
            this.nativeResources.tryCleanup();
        }
        this.checkSession();
        return new EagerOperationBuilder(this, type, name);
    }

    long nativeHandle() {
        this.checkSession();
        return this.nativeHandle;
    }

    ResourceCleanupStrategy resourceCleanupStrategy() {
        return this.resourceCleanupStrategy;
    }

    private EagerSession(Options options, ReferenceQueue<Object> garbageQueue) {
        this.nativeResources = new NativeResourceCollector(garbageQueue);
        this.nativeHandle = EagerSession.allocate(options.async, options.devicePlacementPolicy.code, options.config);
        this.resourceCleanupStrategy = options.resourceCleanupStrategy;
        if (this.resourceCleanupStrategy == ResourceCleanupStrategy.IN_BACKGROUND) {
            this.nativeResources.startCleanupThread();
        }
    }

    private void checkSession() {
        if (this.nativeHandle == 0L) {
            throw new IllegalStateException("Eager session has been closed");
        }
    }

    private static native long allocate(boolean var0, int var1, byte[] var2);

    private static native void delete(long var0);

    static {
        TensorFlow.init();
    }

    private static class NativeResourceCollector {
        private final ExecutorService cleanupService = Executors.newSingleThreadExecutor();
        private final Map<NativeReference, Void> nativeRefs = new IdentityHashMap<NativeReference, Void>();
        private final ReferenceQueue<Object> garbageQueue;
        private volatile boolean cleanupInBackground = false;

        NativeResourceCollector(ReferenceQueue<Object> garbageQueue) {
            this.garbageQueue = garbageQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attach(NativeReference nativeRef) {
            Map<NativeReference, Void> map = this.nativeRefs;
            synchronized (map) {
                this.nativeRefs.put(nativeRef, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void detach(NativeReference nativeRef) {
            Map<NativeReference, Void> map = this.nativeRefs;
            synchronized (map) {
                this.nativeRefs.remove(nativeRef);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void delete(NativeReference nativeRef) {
            Map<NativeReference, Void> map = this.nativeRefs;
            synchronized (map) {
                if (!this.nativeRefs.keySet().remove(nativeRef)) {
                    return;
                }
            }
            nativeRef.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void deleteAll() {
            Map<NativeReference, Void> map = this.nativeRefs;
            synchronized (map) {
                for (NativeReference nativeRef : this.nativeRefs.keySet()) {
                    nativeRef.delete();
                }
                this.nativeRefs.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void tryCleanup() {
            Map<NativeReference, Void> map = this.nativeRefs;
            synchronized (map) {
                Reference<Object> nativeRef;
                while ((nativeRef = this.garbageQueue.poll()) != null) {
                    this.delete((NativeReference)nativeRef);
                }
            }
        }

        synchronized void startCleanupThread() {
            if (this.cleanupInBackground) {
                return;
            }
            try {
                this.cleanupInBackground = true;
                this.cleanupService.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (NativeResourceCollector.this.cleanupInBackground) {
                                NativeReference nativeRef = (NativeReference)NativeResourceCollector.this.garbageQueue.remove();
                                NativeResourceCollector.this.delete(nativeRef);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception e) {
                this.cleanupInBackground = false;
                throw e;
            }
        }

        void stopCleanupThread() {
            this.cleanupInBackground = false;
            this.cleanupService.shutdownNow();
        }
    }

    static abstract class NativeReference
    extends PhantomReference<Object> {
        private final NativeResourceCollector nativeResources;

        public NativeReference(EagerSession session, Object referent) {
            super(referent, session.nativeResources.garbageQueue);
            session.checkSession();
            this.nativeResources = session.nativeResources;
            this.nativeResources.attach(this);
        }

        @Override
        public void clear() {
            this.nativeResources.detach(this);
            super.clear();
        }

        abstract void delete();
    }

    public static class Options {
        private boolean async = false;
        private DevicePlacementPolicy devicePlacementPolicy = DevicePlacementPolicy.SILENT;
        private ResourceCleanupStrategy resourceCleanupStrategy = ResourceCleanupStrategy.IN_BACKGROUND;
        private byte[] config = null;

        public Options async(boolean value) {
            this.async = value;
            return this;
        }

        public Options devicePlacementPolicy(DevicePlacementPolicy value) {
            this.devicePlacementPolicy = value;
            return this;
        }

        public Options resourceCleanupStrategy(ResourceCleanupStrategy value) {
            this.resourceCleanupStrategy = value;
            return this;
        }

        public Options config(byte[] value) {
            this.config = value;
            return this;
        }

        public EagerSession build() {
            return new EagerSession(this, new ReferenceQueue());
        }

        EagerSession buildForGcTest(ReferenceQueue<Object> gcQueue) {
            return new EagerSession(this, gcQueue);
        }

        private Options() {
        }
    }

    public static enum ResourceCleanupStrategy {
        IN_BACKGROUND,
        ON_SAFE_POINTS,
        ON_SESSION_CLOSE;

    }

    public static enum DevicePlacementPolicy {
        EXPLICIT(0),
        WARN(1),
        SILENT(2),
        SILENT_FOR_INT32(3);

        private final int code;

        private DevicePlacementPolicy(int code) {
            this.code = code;
        }
    }
}

