/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.nlp2cron.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CrondConfig {
    public String modelPath = "src\\main\\resources\\model";
    public JSONObject word2id = null;
    public List<String> outputStrs = null;
    public static Map<Integer, String> id2str = new HashMap<Integer, String>();
    public static Map<String, Integer> str2id = new HashMap<String, Integer>();

    public CrondConfig() {
        try {
            InputStream inputStream = CrondConfig.class.getResourceAsStream("/word2id.json");
            String mapping = IOUtils.toString(inputStream, "utf-8");
            this.word2id = JSON.parseObject(mapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.outputStrs = Arrays.asList("#", "*", "0", "S", "?", "E", "1", "2", "3", "5", "4", "7", "8", "6", "9", "/", "<UNK>");
        for (int i = 0; i < this.outputStrs.size(); ++i) {
            str2id.put(this.outputStrs.get(i), i);
            id2str.put(i, this.outputStrs.get(i));
        }
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public JSONObject getWord2id() {
        return this.word2id;
    }

    public void setWord2id(JSONObject word2id) {
        this.word2id = word2id;
    }

    public List<String> getOutputStrs() {
        return this.outputStrs;
    }

    public void setOutputStrs(List<String> outputStrs) {
        this.outputStrs = outputStrs;
    }

    public static Map<Integer, String> getId2str() {
        return id2str;
    }

    public static void setId2str(Map<Integer, String> id2str) {
        CrondConfig.id2str = id2str;
    }

    public static Map<String, Integer> getStr2id() {
        return str2id;
    }

    public static void setStr2id(Map<String, Integer> str2id) {
        CrondConfig.str2id = str2id;
    }
}

