/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DatasetToGraph
extends PrimitiveOp
implements Operand<String> {
    private Output<String> graph;

    public static DatasetToGraph create(Scope scope, Operand<?> inputDataset, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("DatasetToGraph", scope.makeOpName("DatasetToGraph"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.statefulWhitelist == null) continue;
                String[] statefulWhitelistArray = new String[opts.statefulWhitelist.size()];
                for (int i = 0; i < statefulWhitelistArray.length; ++i) {
                    statefulWhitelistArray[i] = (String)opts.statefulWhitelist.get(i);
                }
                opBuilder.setAttr("stateful_whitelist", statefulWhitelistArray);
            }
        }
        return new DatasetToGraph(opBuilder.build());
    }

    public static Options statefulWhitelist(List<String> statefulWhitelist) {
        return new Options().statefulWhitelist(statefulWhitelist);
    }

    public Output<String> graph() {
        return this.graph;
    }

    @Override
    public Output<String> asOutput() {
        return this.graph;
    }

    private DatasetToGraph(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.graph = operation.output(outputIdx++);
    }

    public static class Options {
        private List<String> statefulWhitelist;

        public Options statefulWhitelist(List<String> statefulWhitelist) {
            this.statefulWhitelist = statefulWhitelist;
            return this;
        }

        private Options() {
        }
    }
}

