/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TensorListStack<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> tensor;

    public static <T> TensorListStack<T> create(Scope scope, Operand<?> inputHandle, Operand<Integer> elementShape, Class<T> elementDtype, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("TensorListStack", scope.makeOpName("TensorListStack"));
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("element_dtype", DataType.fromClass(elementDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.numElements == null) continue;
                opBuilder.setAttr("num_elements", opts.numElements);
            }
        }
        return new TensorListStack<T>(opBuilder.build());
    }

    public static Options numElements(Long numElements) {
        return new Options().numElements(numElements);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    private TensorListStack(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static class Options {
        private Long numElements;

        public Options numElements(Long numElements) {
            this.numElements = numElements;
            return this;
        }

        private Options() {
        }
    }
}

