/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CombinedNonMaxSuppression
extends PrimitiveOp {
    private Output<Float> nmsedBoxes;
    private Output<Float> nmsedScores;
    private Output<Float> nmsedClasses;
    private Output<Integer> validDetections;

    public static CombinedNonMaxSuppression create(Scope scope, Operand<Float> boxes, Operand<Float> scores, Operand<Integer> maxOutputSizePerClass, Operand<Integer> maxTotalSize, Operand<Float> iouThreshold, Operand<Float> scoreThreshold, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CombinedNonMaxSuppression", scope.makeOpName("CombinedNonMaxSuppression"));
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(scores.asOutput());
        opBuilder.addInput(maxOutputSizePerClass.asOutput());
        opBuilder.addInput(maxTotalSize.asOutput());
        opBuilder.addInput(iouThreshold.asOutput());
        opBuilder.addInput(scoreThreshold.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.padPerClass != null) {
                    opBuilder.setAttr("pad_per_class", opts.padPerClass);
                }
                if (opts.clipBoxes == null) continue;
                opBuilder.setAttr("clip_boxes", opts.clipBoxes);
            }
        }
        return new CombinedNonMaxSuppression(opBuilder.build());
    }

    public static Options padPerClass(Boolean padPerClass) {
        return new Options().padPerClass(padPerClass);
    }

    public static Options clipBoxes(Boolean clipBoxes) {
        return new Options().clipBoxes(clipBoxes);
    }

    public Output<Float> nmsedBoxes() {
        return this.nmsedBoxes;
    }

    public Output<Float> nmsedScores() {
        return this.nmsedScores;
    }

    public Output<Float> nmsedClasses() {
        return this.nmsedClasses;
    }

    public Output<Integer> validDetections() {
        return this.validDetections;
    }

    private CombinedNonMaxSuppression(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.nmsedBoxes = operation.output(outputIdx++);
        this.nmsedScores = operation.output(outputIdx++);
        this.nmsedClasses = operation.output(outputIdx++);
        this.validDetections = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean padPerClass;
        private Boolean clipBoxes;

        public Options padPerClass(Boolean padPerClass) {
            this.padPerClass = padPerClass;
            return this;
        }

        public Options clipBoxes(Boolean clipBoxes) {
            this.clipBoxes = clipBoxes;
            return this;
        }

        private Options() {
        }
    }
}

