/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.nlp2cron.handler;

import cn.langpy.nlp2cron.core.TimeType;
import java.time.LocalDate;

public class NumUtil {
    public static String cronHandler(String re, TimeType timeType) {
        CharSequence[] reSplit = re.split("#");
        if (timeType == TimeType.today) {
            LocalDate now = LocalDate.now();
            re = (String)reSplit[0] + " " + (String)reSplit[1] + " " + (String)reSplit[2] + " " + now.getDayOfMonth() + " " + now.getMonth().getValue() + " ? " + now.getYear();
        } else if (timeType == TimeType.tomorrow) {
            LocalDate now = LocalDate.now().plusDays(1L);
            re = (String)reSplit[0] + " " + (String)reSplit[1] + " " + (String)reSplit[2] + " " + now.getDayOfMonth() + " " + now.getMonth().getValue() + " ? " + now.getYear();
        } else {
            re = String.join((CharSequence)" ", reSplit);
        }
        return re;
    }

    public static String dateHandler(String re, TimeType timeType) {
        if (timeType == TimeType.today) {
            LocalDate now = LocalDate.now();
            re = now.getYear() + "-" + now.getMonthValue() + "-" + now.getDayOfMonth();
            return re;
        }
        if (timeType == TimeType.tomorrow) {
            LocalDate now = LocalDate.now().plusDays(1L);
            re = now.getYear() + "-" + now.getMonthValue() + "-" + now.getDayOfMonth();
            return re;
        }
        return null;
    }

    public static String dateTimeHandler(String re, TimeType timeType) {
        String[] reSplit = re.split("#");
        if (timeType == TimeType.today) {
            LocalDate now = LocalDate.now();
            re = now.getYear() + "-" + now.getMonthValue() + "-" + now.getDayOfMonth() + " " + reSplit[2] + ":" + reSplit[1] + ":" + reSplit[0];
            return re;
        }
        if (timeType == TimeType.tomorrow) {
            LocalDate now = LocalDate.now().plusDays(1L);
            re = now.getYear() + "-" + now.getMonthValue() + "-" + now.getDayOfMonth() + " " + reSplit[2] + ":" + reSplit[1] + ":" + reSplit[0];
            return re;
        }
        return null;
    }

    public static String timeHandler(String re, TimeType timeType) {
        String[] reSplit = re.split("#");
        return reSplit[2] + ":" + reSplit[1] + ":" + reSplit[0];
    }

    public static TimeType getTimeType(String message) {
        if (message.matches(".*(\u660e\u5929|\u660e\u65e9|\u660e\u665a).*")) {
            return TimeType.tomorrow;
        }
        if (message.matches(".*(\u4eca\u5929|\u4eca\u665a|\u4eca\u65e9|\u65e9\u4e0a|\u665a\u4e0a).*") && !message.contains("\u6bcf") || message.matches(".{1,2}(:|\u70b9)")) {
            return TimeType.today;
        }
        return TimeType.others;
    }
}

