/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.InvokedInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.service.MethodNodeService;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.InvalidAuthInfoException;
import cn.langpy.kotime.util.ThrowException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

public class KoUtil {
    private static Logger log = Logger.getLogger(KoUtil.class.toString());
    private static final String koTimeSecret = UUID.randomUUID().toString().replace("-", "");
    private static final List<Integer> choices = KoUtil.randomSecretIndexs();
    private static Map<String, Object> caches = new HashMap<String, Object>();

    public static String login(String userName) {
        String token = KoUtil.encode(userName + "KOTO" + (System.currentTimeMillis() + Context.getConfig().getAuthExpire() * 1000L));
        return token;
    }

    public static void checkLogin(String token) {
        KoUtil.decode(token);
    }

    public static boolean isLogin(String token) {
        try {
            KoUtil.decode(token);
            return true;
        }
        catch (Exception verificationException) {
            return false;
        }
    }

    public static void setDataSource(DataSource dataSource) {
        caches.put("dataSource", dataSource);
    }

    public static DataSource getDataSource() {
        return (DataSource)caches.get("dataSource");
    }

    public static void setStringRedisTemplate(RedisTemplate redisTemplate) {
        caches.put("redisTemplate", redisTemplate);
    }

    public static StringRedisTemplate getStringRedisTemplate() {
        return (StringRedisTemplate)caches.get("redisTemplate");
    }

    public static void throwException(Exception e) {
        ThrowException throwException = new ThrowException(e);
        throw throwException;
    }

    public static void recordException(Exception e) {
        ExceptionNode exception = new ExceptionNode();
        exception.setName(e.getClass().getSimpleName());
        exception.setClassName(e.getClass().getName());
        exception.setMessage(e.getMessage());
        exception.setId(exception.getClassName() + "." + exception.getName());
        MethodNode current = KoUtil.getCurrentMethodInfo();
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(current.getClassName())) continue;
            exception.setValue(stackTraceElement.getLineNumber());
            InvokedInfo invokedInfo = new InvokedInfo();
            invokedInfo.setCurrent(current);
            invokedInfo.setException(exception);
            InvokedQueue.add(invokedInfo);
            InvokedQueue.wake();
            break;
        }
    }

    public static MethodNode getCurrentMethodInfo() {
        MethodNode methodNode = MethodNodeService.getParentMethodNode();
        return methodNode;
    }

    public static void clearCaches() {
        caches.clear();
    }

    private static List<Integer> randomSecretIndexs() {
        ArrayList<Integer> choices = new ArrayList<Integer>();
        Random random = new Random();
        for (int i = 0; i < 20; ++i) {
            int intrandom = random.nextInt(20);
            if (choices.contains(intrandom)) continue;
            choices.add(intrandom);
        }
        return choices;
    }

    private static String encode(String text) {
        Base64.Encoder encoder = Base64.getEncoder();
        Object encode = encoder.encodeToString(text.getBytes());
        int choicesSize = choices.size();
        for (int i = 0; i < choicesSize; ++i) {
            Integer choice = choices.get(i);
            String pre = ((String)encode).substring(0, choice);
            String suf = ((String)encode).substring(choice);
            encode = pre + koTimeSecret.substring(i, i + 1) + suf;
        }
        return encode;
    }

    private static String decode(String token) {
        int tokenLength = ((String)token).length();
        int choicesSize = choices.size();
        for (int i = choicesSize - 1; i >= 0; --i) {
            Integer choice = choices.get(i);
            String pre = ((String)token).substring(0, choice);
            String suf = ((String)token).substring(choice + 1);
            String secretAt = koTimeSecret.substring(i, i + 1);
            if (choice + 1 > tokenLength) {
                throw new InvalidAuthInfoException("error token!");
            }
            String tokenAt = ((String)token).substring(choice, choice + 1);
            if (!secretAt.equals(tokenAt)) {
                throw new InvalidAuthInfoException("error token!");
            }
            token = pre + suf;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] decode = decoder.decode((String)token);
        String decodeStr = new String(decode);
        String[] split = decodeStr.split("KOTO");
        Long expireTime = Long.valueOf(split[1]);
        if (expireTime < System.currentTimeMillis()) {
            throw new InvalidAuthInfoException("expired time!");
        }
        return decodeStr;
    }

    public static void setProperty(String propertyName, String propertyValue) {
        Context.getDynamicProperties().setProperty(propertyName, propertyValue);
    }

    public static String getProperty(String propertyName) {
        String value = Context.getDynamicProperties().getProperty(propertyName);
        return value;
    }

    public static int getPropertyAsInteger(String propertyName) {
        String value = KoUtil.getProperty(propertyName);
        return Integer.valueOf(value);
    }

    public static double getPropertyAsDouble(String propertyName) {
        String value = KoUtil.getProperty(propertyName);
        return Double.valueOf(value);
    }

    public static double getPropertyAsFloat(String propertyName) {
        String value = KoUtil.getProperty(propertyName);
        return Float.valueOf(value).floatValue();
    }

    public static boolean getPropertyAsBoolean(String propertyName) {
        String value = KoUtil.getProperty(propertyName);
        if ("true".equals(value) || "false".equals(value)) {
            return Boolean.valueOf(value);
        }
        throw new RuntimeException("can not convert null value to boolean value.");
    }

    public static List<String> getPropertyAsList(String propertyName, String split) {
        String value = KoUtil.getProperty(propertyName);
        if (value == null) {
            throw new RuntimeException("can not convert null value to list values.");
        }
        String[] split1 = value.split(split);
        return Arrays.stream(split1).collect(Collectors.toList());
    }

    public static Properties getLanguageDict(String language) {
        Properties properties = new Properties();
        if (!StringUtils.hasText((String)language)) {
            language = Context.getConfig().getLanguage();
        }
        ClassPathResource classPathResource = new ClassPathResource("kostatic/dict/" + language + ".properties");
        try (InputStream inputStream = classPathResource.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            properties.load(inputStreamReader);
        }
        catch (UnsupportedEncodingException e) {
            log.severe("kotime=>" + Context.getConfig().getLanguage() + ".properties requires utf-8.");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            log.warning("kotime=>No " + Context.getConfig().getLanguage() + ".properties found so that you can not use language properties to set.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getVerssion() {
        Properties properties = new Properties();
        ClassPathResource classPathResource = new ClassPathResource("koapp.properties");
        try (InputStream inputStream = classPathResource.getInputStream();
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            properties.load(inputStreamReader);
        }
        catch (UnsupportedEncodingException e) {
            log.severe("kotime=>koapp.properties requires utf-8.");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            log.warning("kotime=>No koapp.properties found.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties.getProperty("ko-time.version");
    }
}

