/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.model.UserInfo;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.InvalidAuthInfoException;
import cn.langpy.kotime.util.KoUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime"})
public class KoInitController {
    private static Logger log = Logger.getLogger(KoInitController.class.toString());
    @Value(value="${ko-time.user-name:}")
    private String userName;
    @Value(value="${ko-time.password:}")
    private String password;
    private final Pattern pattern = Pattern.compile("\\{\\{[a-zA-Z0-9\\.-]+\\}\\}");
    private final ClassPathResource kotimeViewerResource = new ClassPathResource("kotime.html");
    private final String uiKitCssText = this.getResourceText("kostatic/uikit.min.css");
    private final String uiKitJsText = this.getResourceText("kostatic/uikit.min.js");
    private final String metricFlowJsText = this.getResourceText("kostatic/Metricflow.js");
    private final String jQueryJsText = this.getResourceText("kostatic/JQuery.min.js");
    private final String uiKitIconsJs = this.getResourceText("kostatic/uikit-icons.js");
    private final String KoTimeUtil = this.getResourceText("kostatic/util.js");
    private final String commonCss = this.getResourceText("kostatic/common.css");

    @PostMapping(value={"/login"})
    @ResponseBody
    public Map login(@RequestBody UserInfo userInfo) {
        if (null == userInfo || !StringUtils.hasText((String)userInfo.getUserName()) || !StringUtils.hasText((String)userInfo.getPassword())) {
            throw new InvalidAuthInfoException("failed to login for kotime,please fill userName and password!");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.userName.equals(userInfo.getUserName()) && this.password.equals(userInfo.getPassword())) {
            String token = KoUtil.login(userInfo.getUserName());
            map.put("state", 1);
            map.put("token", token);
            return map;
        }
        map.put("state", 0);
        return map;
    }

    @GetMapping(value={"/isLogin"})
    @ResponseBody
    public Map isLogin(String kotoken) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", 1);
        boolean checkLogin = false;
        if (StringUtils.hasText((String)kotoken)) {
            checkLogin = kotoken.equals(Context.getConfig().getStaticToken()) ? true : KoUtil.isLogin(kotoken);
        }
        map.put("isLogin", checkLogin ? 1 : 0);
        return map;
    }

    @GetMapping
    public void index(String kotoken, String charset, String language, HttpServletResponse response, HttpServletRequest request) {
        if (!Context.getConfig().getEnable().booleanValue()) {
            return;
        }
        if (!StringUtils.hasText((String)charset)) {
            charset = "utf-8";
        }
        response.setContentType("text/html;charset=" + charset);
        try (InputStream inputStream = this.kotimeViewerResource.getInputStream();
             InputStreamReader streamReader = new InputStreamReader(inputStream, "utf-8");
             BufferedReader reader = new BufferedReader(streamReader);
             PrintWriter out = response.getWriter();){
            Properties languageDict = KoUtil.getLanguageDict(language);
            String context = request.getContextPath();
            if (StringUtils.hasText((String)Context.getConfig().getContextPath())) {
                context = Context.getConfig().getContextPath();
            }
            StringBuilder stringBuilder = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                if ((line = this.formatStaticResource(line, context, kotoken)).indexOf("{{") > -1) {
                    line = this.formatLanguageDesc(line, languageDict);
                }
                stringBuilder.append(line + "\n");
            }
            line = stringBuilder.toString();
            out.print(line);
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatStaticResource(String line, String context, String kotoken) {
        boolean staticTokenVisit = false;
        if (StringUtils.hasText((String)kotoken)) {
            staticTokenVisit = true;
        }
        if (line.indexOf("globalThresholdValue") > -1) {
            line = line.replace("globalThresholdValue", "" + Context.getConfig().getThreshold());
        } else if (line.indexOf("globalNeedLoginValue") > -1) {
            line = line.replace("globalNeedLoginValue", "" + Context.getConfig().getAuthEnable());
        } else if (line.indexOf("contextPath") > -1) {
            line = line.replace("contextPath", context);
        } else if (line.indexOf("exceptionTitleStyle") > -1) {
            line = line.replace("exceptionTitleStyle", Context.getConfig().getExceptionEnable() == true ? "" : "display:none;");
        } else if (line.indexOf("UIKitCss") > -1) {
            line = line.replace("UIKitCss", this.uiKitCssText);
        } else if (line.indexOf("UIKitJs") > -1) {
            line = line.replace("UIKitJs", this.uiKitJsText);
        } else if (line.indexOf("MetricFlowJs") > -1) {
            line = line.replace("MetricFlowJs", this.metricFlowJsText);
        } else if (line.indexOf("jQueryJs") > -1) {
            line = line.replace("jQueryJs", this.jQueryJsText);
        } else if (line.indexOf("uiKitIconsJs") > -1) {
            line = line.replace("uiKitIconsJs", this.uiKitIconsJs);
        } else if (line.indexOf("staticTokenVisitValue") > -1) {
            line = line.replace("staticTokenVisitValue", "" + staticTokenVisit);
        } else if (line.indexOf("staticTokenValue") > -1) {
            line = line.replace("staticTokenValue", "'" + kotoken + "'");
        } else if (line.indexOf("KoTimeUtil") > -1) {
            line = line.replace("KoTimeUtil", this.KoTimeUtil);
        } else if (line.indexOf("koTimeVersionValue") > -1) {
            line = line.replace("koTimeVersionValue", "'" + KoUtil.getVerssion() + "'");
        } else if (line.indexOf("abbreviationEnableValue") > -1) {
            line = line.replace("abbreviationEnableValue", "" + Context.getConfig().getAbbreviationEnable());
        } else if (line.indexOf("commonCss") > -1) {
            line = line.replace("commonCss", this.commonCss);
        }
        return line;
    }

    private String formatLanguageDesc(String line, Properties languageDict) {
        String languageKey = this.getLanguageKey(line);
        if (languageKey != null) {
            String key = languageKey.replaceAll("\\{|\\}", "");
            String value = languageDict.getProperty(key);
            line = line.replace(languageKey, value);
        }
        return line;
    }

    private String getLanguageKey(String line) {
        Matcher m = this.pattern.matcher(line);
        String key = null;
        if (m.find()) {
            key = m.group(0);
        }
        return key;
    }

    /*
     * Exception decompiling
     */
    private String getResourceText(String fileName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

