/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.annotation.KoListener;
import cn.langpy.kotime.config.DefaultConfig;
import cn.langpy.kotime.handler.InvokedHandler;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.service.InvokedQueue;
import cn.langpy.kotime.util.Common;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.DataBaseException;
import jakarta.annotation.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class LoadConfig {
    private static Logger log = Logger.getLogger(LoadConfig.class.toString());
    @Value(value="${server.port:8080}")
    private Integer serverPort;
    @Value(value="${server.servlet.context-path:}")
    private String serverContext;
    @Value(value="${ko-time.mail-enable:false}")
    private Boolean mailEnable;
    @Resource
    private DefaultConfig defaultConfig;
    @Resource
    private ApplicationContext applicationContext;

    public void initConfig() {
        String[] names;
        DefaultConfig config = this.improveConfig();
        this.configDataSource(config);
        this.configRedisTemplate(config);
        Context.setConfig(config);
        for (String name : names = this.applicationContext.getBeanNamesForType(GraphService.class)) {
            GraphService bean = (GraphService)this.applicationContext.getBean(name);
            if (null == bean) continue;
            Component annotation = bean.getClass().getAnnotation(Component.class);
            if (!config.getSaver().equals(annotation.value())) continue;
            Context.setSaver(bean);
            break;
        }
        if (null == Context.getSaver()) {
            throw new DataBaseException("error `ko-time.saver=" + config.getSaver() + "`, and you can only choose an option in {memory,database,redis} for `ko-time.saver=`!");
        }
        log.info("kotime=>loading config");
        if (StringUtils.hasText((String)config.getContextPath())) {
            log.info("kotime=>view:" + Context.getConfig().getContextPath() + "/koTime");
        } else {
            log.info("kotime=>view:http://localhost:" + this.serverPort + this.serverContext + "/koTime");
        }
        this.initMethodHandlers();
        this.loadPropertyFile();
    }

    public DefaultConfig improveConfig() {
        DefaultConfig config = new DefaultConfig();
        config.setLogEnable(this.defaultConfig.getLogEnable());
        config.setThreshold(this.defaultConfig.getThreshold());
        config.setExceptionEnable(this.defaultConfig.getExceptionEnable());
        config.setSaver(this.defaultConfig.getSaver());
        config.setEnable(this.defaultConfig.getEnable());
        config.setDataPrefix(this.defaultConfig.getDataPrefix() == null ? (StringUtils.hasText((String)this.serverContext) ? this.serverContext.substring(1) : "KOTIME") : this.defaultConfig.getDataPrefix());
        config.setContextPath(this.defaultConfig.getContextPath());
        config.setLanguage(this.defaultConfig.getLanguage() == null ? "chinese" : this.defaultConfig.getLanguage());
        config.setThreadNum(this.defaultConfig.getThreadNum() == null ? 2 : this.defaultConfig.getThreadNum());
        config.setDiscardRate(this.defaultConfig.getDiscardRate() == null ? 0.3 : this.defaultConfig.getDiscardRate());
        config.setAuthExpire(this.defaultConfig.getAuthExpire() == null ? 43200L : this.defaultConfig.getAuthExpire());
        config.setAuthEnable(this.defaultConfig.getAuthEnable() == null ? false : this.defaultConfig.getAuthEnable());
        config.setParamAnalyse(this.defaultConfig.getParamAnalyse() == null ? true : this.defaultConfig.getParamAnalyse());
        config.setDataReset(this.defaultConfig.getDataReset() == null ? false : this.defaultConfig.getDataReset());
        config.setVersionNotice(this.defaultConfig.getVersionNotice() == null ? true : this.defaultConfig.getVersionNotice());
        config.setStaticToken(this.defaultConfig.getStaticToken());
        config.setAbbreviationEnable(this.defaultConfig.getAbbreviationEnable() == null ? true : this.defaultConfig.getAbbreviationEnable());
        config.setMailEnable(this.defaultConfig.getMailEnable());
        config.setMailProtocol(this.defaultConfig.getMailProtocol() == null ? "smtp" : this.defaultConfig.getMailProtocol());
        config.setMailHost(this.defaultConfig.getMailHost() == null ? "smtp.qq.com" : this.defaultConfig.getMailHost());
        config.setMailPort(this.defaultConfig.getMailPort() == null ? 587 : this.defaultConfig.getMailPort());
        config.setMailEncoding(this.defaultConfig.getMailEncoding() == null ? "UTF-8" : this.defaultConfig.getMailEncoding());
        config.setMailThreshold(this.defaultConfig.getMailThreshold() == null ? 4 : this.defaultConfig.getMailThreshold());
        config.setMailScope(this.defaultConfig.getMailScope() == null ? "Controller" : this.defaultConfig.getMailScope());
        config.setMailUser(this.defaultConfig.getMailUser());
        config.setMailCode(this.defaultConfig.getMailCode());
        config.setMailReceivers(this.defaultConfig.getMailReceivers());
        config.setPropertyFile(this.defaultConfig.getPropertyFile() == null ? "dynamic.properties" : this.defaultConfig.getPropertyFile());
        return config;
    }

    public void loadPropertyFile() {
        ClassPathResource classPathResource = new ClassPathResource(Context.getConfig().getPropertyFile());
        try (InputStream inputStream = classPathResource.getInputStream();){
            Context.getDynamicProperties().load(inputStream);
        }
        catch (UnsupportedEncodingException e) {
            log.severe("kotime=>dynamic.properties requires utf-8.");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            log.warning("kotime=>No dynamic.properties found so that you can not use dynamic properties to set.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void configDataSource(DefaultConfig config) {
        if (!"database".equals(config.getSaver())) {
            return;
        }
        try {
            DataSource dataSource = (DataSource)this.applicationContext.getBean(DataSource.class);
            Context.setDataSource(dataSource);
        }
        catch (NoUniqueBeanDefinitionException e) {
            if (Common.isEmpty(config.getDataSource())) {
                log.severe("kotime=>No unique bean of type 'DataSource' available,you can define it by `ko-time.data-source=xxx`");
            } else {
                DataSource dataSource = (DataSource)this.applicationContext.getBean(config.getDataSource(), DataSource.class);
                Context.setDataSource(dataSource);
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.severe("kotime=>No qualifying bean of type 'DataSource' available,but you can ignore it if your KoTime saver is `ko-time.saver=memory`");
        }
    }

    public void configRedisTemplate(DefaultConfig config) {
        if (!"redis".equals(config.getSaver())) {
            return;
        }
        try {
            StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
            Context.setStringRedisTemplate(redisTemplate);
        }
        catch (NoUniqueBeanDefinitionException e) {
            if (!Common.isEmpty(config.getRedisTemplate())) {
                StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(config.getRedisTemplate(), StringRedisTemplate.class);
                Context.setStringRedisTemplate(redisTemplate);
            } else {
                Map beansOfType = this.applicationContext.getBeansOfType(StringRedisTemplate.class);
                log.warning("kotime=>No unique bean of type 'StringRedisTemplate' available,you can define it by `ko-time.redis-template=xxx`,and you can choose a name in " + beansOfType.keySet().stream().collect(Collectors.toList()));
                log.warning("kotime=>Now the firsr was be set.");
                Context.setStringRedisTemplate((StringRedisTemplate)beansOfType.values().stream().collect(Collectors.toList()).get(0));
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.severe("kotime=>No qualifying bean of type 'StringRedisTemplate' available,but you can ignore it if your KoTime saver is `ko-time.saver=memory`");
        }
        catch (NoClassDefFoundError error) {
            log.severe("kotime=>No dependency named `spring-boot-starter-data-redis` found,please add a denpendency in pom.xml for redis.");
        }
    }

    public void initMethodHandlers() {
        String[] names;
        for (String name : names = this.applicationContext.getBeanNamesForType(InvokedHandler.class)) {
            KoListener annotation;
            InvokedHandler bean;
            if ("emailHandler".equals(name) && !this.mailEnable.booleanValue() || null == (bean = (InvokedHandler)this.applicationContext.getBean(name)) || null == (annotation = bean.getClass().getAnnotation(KoListener.class))) continue;
            log.info("kotime=>loading InvokedHandler:" + bean.getClass().getSimpleName());
            Context.addInvokedHandler(bean);
        }
        for (int i = 0; i < Context.getConfig().getThreadNum(); ++i) {
            new Thread(() -> InvokedQueue.onInveked()).start();
        }
    }
}

